<?php

namespace App\Http\Controllers\AppHandler;

use App\Http\Controllers\Controller;
use App\Models\App_Settings;
use App\Models\AUser;
use App\Models\DB_Daily;
use App\Models\DB_Settings;
use Carbon\Carbon;
use Illuminate\Http\Request;

class Splash extends Controller
{

  
public static function usercheck(Request $request)
{

    $android_id = $request->input('android_id');

    if (!$android_id) {
        return response()->json([
            'success' => false,
            'message' => 'Device ID is required.',
        ], 200);
    }

    $today = Carbon::today();
    $settings = DB_Settings::find(1);

    $user = AUser::where('android_id', $android_id)->first();
    if (!$user) {
        return response()->json([
            'success' => false,
            'message' => 'User not found!',
            'settings' => $settings,
        ], 400);
    }

    $u_id = $user->u_id;

    // Daily streak initialization
    $userStreak = DB_Daily::where('u_id', $u_id)->first();
    if (!$userStreak) {
        $userStreak = new DB_Daily();
        $userStreak->u_id = $u_id;
        $userStreak->status = 0;
        $userStreak->save();
    }

    // Only initialize streak if status = 0
    if ($userStreak->status == 0) {
        $startDate = $today->copy();
        for ($i = 1; $i <= 7; $i++) {
            $userStreak->{'day' . $i} = $startDate->copy()->addDays($i - 1)->format('Y-m-d');
        }
        $userStreak->status = 1;
        $userStreak->save();
    }

    // Reset streak if 15th day is collected
    if ($userStreak->day15 === 'collected') {
        $startDate = $today->copy();
        for ($i = 1; $i <= 7; $i++) {
            $userStreak->{'day' . $i} = $startDate->copy()->addDays($i - 1)->format('Y-m-d');
        }
        $userStreak->status = 1;
        $userStreak->save();
    }

    return response()->json([
        'success' => true,
        'message' => 'Splash data received successfully.',
        'user' => $user,
        'setting' => $settings,
    ], 200);
}




}
