<?php
include("code/config.php");

?>
<!DOCTYPE html>
<html lang="en">


<meta http-equiv="content-type" content="text/html;charset=UTF-8" />
<head>
    <?php include("code/meta.php") ?>
    <style>
        .aletrtErr {
            padding: 10px;
            border-radius: 10px;
            background: <?php if($err){ ?>var(--bs-danger)<?php }else{ ?>var(--bs-success)<?php } ?>;
            color: white;
        }

        .cpa{
            font-size: larger;
            font-weight: bold;

        }
    </style>

</head>
<body>
    <?php include("code/head.php") ?>
    <?php include("code/sidebar.php") ?>
    <?php include("modal/soldDetails.php") ?>

    <div class="main-content app-content">
        <div class="container-fluid">
            <div class="my-4 page-header-breadcrumb d-flex align-items-center justify-content-between flex-wrap gap-2">
                <div>
                    <h1 class="page-title fw-medium fs-18 mb-2">
                        <?php echo $TITLE; ?>
                    </h1>
                    <div class="">
                        <nav>
                            <ol class="breadcrumb mb-0">
                                <li class="breadcrumb-item"><a href="javascript:void(0);">Home</a></li>
                                <li class="breadcrumb-item active" aria-current="page"><?php echo $TITLE; ?></li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>

            <div class="mb-4">
                <?php if($msg){ ?><span class="aletrtErr"><?php echo $msg; ?></span><?php } ?>
                <span style="display:none;padding: 10px; border-radius: 10px; background: var(--bs-danger); color: white;" id="alert"></span>
            </div>

            <div class="row">
            <div class="card mb-4 pt-2 ps-3 pb-2">
            	    <form method="post">
            	        <div class="row">
                	        <div class="col-md-4">
                    	        <label>From Date</label>
                    	        <input type="date" class="form-control" name="fromDate" value="<?php if(isset($_POST['fromDate'])) echo $_POST['fromDate']; ?>" required>
                    	    </div>
                    	    <div class="col-md-4">
                    	        <label>To Date</label>
                    	        <input type="date" class="form-control" name="toDate" value="<?php if(isset($_POST['toDate'])) echo $_POST['toDate']; ?>" required>
                    	    </div>
                    	    <div class="col-md-4">
                    	        <button class="btn btn-primary" style="margin-top:26px" name="filetNow">Filter</button>
                    	    </div>
                	    </div>
            	    </form>
            	</div>
            	<div class="row">
            	    <div class="col-md-12 mb-4">
            	        <div class="filter card cm-content-box box-primary ps-2">
            				<div class="content-title pt-3">
            					<div class="cpa">
            						<i class="fa fa-file-lines me-1"></i>Available Users
            					</div>
            					<div class="tools">
            						<a href="javascript:void(0);" class="expand SlideToolHeader"><i
            								class="fa fa-angle-down"></i></a>
            					</div>
            				</div>
            				<div class="cm-content-body form excerpt">
            					<div class="card-body pt-2">
            						<div class="table-responsive">
            							<table id="file-export" class="table table-striped table-bordered text-nowrap w-100" style="min-width: 845px" role="grid" aria-describedby="example_info">
            								<thead>
            									<tr>
            										<th><strong>S/NO</strong></th>
            										<th><strong>Farmer Id</strong></th>
            										<th><strong>Farmer Phone</strong></th>
            										<th><strong>Order Id</strong></th>
            										<th><strong>Order Date</strong></th>
            										<th><strong>Moult</strong></th>
            										<th><strong>Quantity</strong></th>
            										<th><strong>Lot No</strong></th>
            										<th><strong>Sold Details</strong></th>
            									</tr> 
            								</thead>
            								<tbody>
                                            <?php if (!empty($cacoon_yeilds)): ?>
                                                <?php $i = 0; 
                                                $list = explode(",","Eggs,1st Moult,2nd Moult,3rd Moult");?>
                                                <?php foreach ($cacoon_yeilds as $row): ?>
                                                    <tr>
                                                        <td><?php echo ++$i; ?></td>
                                                        <td><?php echo $row['farmer_id']; ?></td>
                                                        <td><?php echo $row['farmer_phone']; ?></td>
                                                        <td><?php echo $row['order_id']; ?></td>
                                                        <td><?php echo date("d/m/Y",strtotime($row['order_date'])); ?></td>
                                                        <td><?php echo $row['indent_type']; ?> - <?php echo $list[$row['indent_moult']]; ?></td>
                                                        <td><?php echo $row['order_quantity']; ?></td>
                                                        <td><?php echo $row['lot_number']; ?></td>
                                                        <td><button type="button" onclick="soldDetails('<?= $row['id']; ?>','<?= strtolower($row['indent_type']); ?>')" class="btn btn-primary mb-2" data-bs-toggle="modal" data-bs-target="#exampleModalCenter"><i class="fa fa-eye"></i></button></td>
                                                    </tr>
                                                <?php endforeach; ?>
                                            <?php endif; ?>

            								</tbody>
            								<script>
            								    function soldDetails(e,t,s=''){
            								        document.getElementById('idBox').value = e;
            								        document.getElementById('dbBox').value = t;
            								        
            								        $.ajax({
                                                        url : 'api/getSolDetails?id='+e+'&type='+t,
                                                        type : 'get',
                                                        success : function (result) {
                                                            document.getElementById('DataHere').innerHTML = result;
                                                        },
                                                        error : function () {
                                                            console.log ('error');
                                                        }
                                                    });
            								    }
            								</script>
            							</table>
            						</div>
            					</div>
            				</div>
            			</div>
            	    </div>
						
            	   
            	</div>
            </div>

        </div>
    </div>



<script>

    

    $(document).ready(function () {
        $('#file-export').DataTable({
			pageLength: 100,
            dom: 'Bfrtip',
            buttons: [
                'copy', 'csv', 'excel', 'pdf', 'print'
            ],
            language: {
                searchPlaceholder: 'Search...',
                sSearch: '',
            },
        });
    });
</script>

<style>
    .dt-search{
        text-align: end;
    }
    table{
        margin-top: 20px !important;
    }

    .dt-paging.paging_full_numbers{
        text-align: end;
    }

    .dt-paging.paging_full_numbers button{
        margin: 0 2px;
        background-color: rgb(115, 93, 255);
        color: white;
        border: none;
        border-radius: 2rem;
        width: 2rem;
        height: 2rem;
    }





</style>

    
<?php include("code/footer.php"); ?>        

<!--**********************************
Main wrapper end
***********************************-->

<!--**********************************
Scripts
***********************************-->
<!-- Required vendors -->
<!-- <script src="vendor/global/global.min.js"></script>
<script src="vendor/jquery-nice-select/js/jquery.nice-select.min.js"></script>		
<script src="vendor/chart-js/chart.bundle.min.js"></script>

</script><script src="vendor/wnumb/wNumb.js"></script>
<script src="js/custom.min.js"></script>
<script src="js/dlabnav-init.js"></script> -->

</body>
</html>


