<?php
include("code/config.php");

?>
<!DOCTYPE html>
<html lang="en">


<meta http-equiv="content-type" content="text/html;charset=UTF-8" />
<head>
    <?php include("code/meta.php") ?>
    <style>
        .aletrtErr {
            padding: 10px;
            border-radius: 10px;
            background: <?php if($err){ ?>var(--bs-danger)<?php }else{ ?>var(--bs-success)<?php } ?>;
            color: white;
        }

        .cpa{
            font-size: larger;
            font-weight: bold;

        }
    </style>

</head>
<body>
    <?php include("code/head.php") ?>
    <?php include("code/sidebar.php") ?>
    <?php include("modal/add-officer.php") ?>
    <?php include("modal/add-message.php") ?>



    <div class="main-content app-content">
        <div class="container-fluid">
            <div class="my-4 page-header-breadcrumb d-flex align-items-center justify-content-between flex-wrap gap-2">
                <div>
                    <h1 class="page-title fw-medium fs-18 mb-2">
                        <?php echo $TITLE; ?>
                    </h1>
                    <div class="">
                        <nav>
                            <ol class="breadcrumb mb-0">
                                <li class="breadcrumb-item"><a href="javascript:void(0);">Home</a></li>
                                <li class="breadcrumb-item active" aria-current="page"><?php echo $TITLE; ?></li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>

            <div class="mb-4">
                <?php if($msg){ ?><span class="aletrtErr"><?php echo $msg; ?></span><?php } ?>
                <span style="display:none;padding: 10px; border-radius: 10px; background: var(--bs-danger); color: white;" id="alert"></span>
            </div>

            <div class="row">

                <div class="container-fluid">
                    <div class="card-body">
                        <div class="mb-4">
                            <?php if($msg){ ?><span class="aletrtErr"><?php echo $msg; ?></span><?php } ?>
                        </div>
                        <ul class="nav nav-pills justify-content-left mb-2" role="tablist">
                            <li class=" nav-item" role="presentation">
                                <a href="#navpills2-1" class="nav-link active" data-bs-toggle="tab" aria-expanded="false" aria-selected="true" role="tab">Extension Officer</a>
                            </li>
                            <li class="nav-item" role="presentation">
                                <a href="#navpills2-2" class="nav-link" data-bs-toggle="tab" aria-expanded="false" aria-selected="false" role="tab" tabindex="-1">Messages</a>
                            </li>
                        </ul>
                        <div class="tab-content">
                            
                            <div id="navpills2-1" class="tab-pane active show" role="tabpanel">
                                <div class="d-flex justify-content-end mb-1 pt-2 ps-2">
                                    <div>
                                        <!-- Button trigger modal -->
                                        <button type="button" class="btn btn-primary mb-2" data-bs-toggle="modal"
                                            data-bs-target="#exampleModalCenter">Add Extension Officer</button>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class=" card p-2 col-md-12 mb-4">
                                        <div class="filter cm-content-box box-primary">
                                            <div class="content-title">
                                                <div class="cpa">
                                                    <i class="fa fa-file-lines me-1"></i>Available Officers
                                                </div>
                                                <div class="tools">
                                                    <a href="javascript:void(0);" class="expand SlideToolHeader"><i
                                                            class="fa fa-angle-down"></i></a>
                                                </div>
                                            </div>
                                            <div class="cm-content-body form excerpt">
                                                <div class="card-body pt-2">
                                                    <div class="table-responsive">
                            
                                                        <table id="file-export" class="table table-striped table-bordered text-nowrap w-100" style="min-width: 845px" role="grid" aria-describedby="example_info">
                                                            <thead>
                                                                <tr>
                                                                    <th><strong>S/NO</strong></th>
                                                                    <th><strong>Name</strong></th>
                                                                    <th><strong>Phone Number</strong></th>
                                                                    <th style="width:85px;"><strong>Actions</strong></th>
                                                                </tr> 
                                                            </thead>
                                                            <tbody>
                                                                <?php
                                                                    $i = 0;

                                                                    if(isset($officers)){
                                                                        foreach($officers as $row){                                                                ?>
                                                                            <tr>
                                                                                <td><?php echo ++$i; ?></td>
                                                                                <td><?php echo $row['contactName']; ?></td>
                                                                                <td><?php echo $row['contactNo']; ?></td>
                                                                                
                                                                                <td>
                                                                                    <form method="post" onsubmit="return confirm('are you sure? this action cannot be undone!')">
                                                                                        <input type="hidden" name="id" value="<?php echo $row['id']; ?>">
                                                                                        <input type="hidden" name="type" value="extensionOfficer">
                                                                                        <button class="btn btn-danger shadow btn-xs sharp rounded-circle" name="del"><i class="fa fa-trash"></i></button>
                                                                                    </form>
                                                                                </td>
                                                                            </tr>
                                                                <?php
                                                                    }
                                                                }
                                                                   
                                                                ?>
                                                                
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div id="navpills2-2" class="tab-pane" role="tabpanel">
                                <div class="d-flex justify-content-end mb-1 pt-2 ps-2">
                                    <div>
                                        <!-- Button trigger modal -->
                                        <button type="button" class="btn btn-primary mb-2" data-bs-toggle="modal"
                                            data-bs-target="#exampleModalCenters">Add Message</button>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="card p-2 col-md-12 mb-4">
                                        <div class="filter cm-content-box box-primary">
                                            <div class="content-title">
                                                <div class="cpa">
                                                    <i class="fa fa-file-lines me-1"></i>All Messages
                                                </div>
                                                <div class="tools">
                                                    <a href="javascript:void(0);" class="expand SlideToolHeader"><i
                                                            class="fa fa-angle-down"></i></a>
                                                </div>
                                            </div>
                                            <div class="cm-content-body form excerpt">
                                                <div class="card-body pt-2">
                                                    <div class="table-responsive">
                            
                                                        <table id="example" class="table table-striped table-bordered text-nowrap w-100" style="min-width: 845px" role="grid" aria-describedby="example_info">
                                                            <thead>
                                                                <tr>
                                                                    <th><strong>S/NO</strong></th>
                                                                    <th><strong>Message</strong></th>
                                                                </tr> 
                                                            </thead>
                                                            <tbody>
                                                                <?php
                                                                    $i = 0;
                                                                    
                                                                    if(isset($messeges)){
                                                                        foreach($messeges as $row){
                                                                ?>
                                                                            <tr>
                                                                                <td><?php echo ++$i; ?></td>
                                                                                <td><?php echo $row['msg']; ?></td>
                                                                            </tr>
                                                                <?php
                                                                        }
                                                                    }
                                                                ?>
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>


                        </div>
                    </div>
                </div>
            </div>
        
        </div>
    </div>



<script>

    

    $(document).ready(function () {
        $('#file-export').DataTable({
			pageLength: 100,
            dom: 'Bfrtip',
            buttons: [
                'copy', 'csv', 'excel', 'pdf', 'print'
            ],
            language: {
                searchPlaceholder: 'Search...',
                sSearch: '',
            },
        });
        $('#example').DataTable({
			pageLength: 100,
            dom: 'Bfrtip',
            buttons: [
                'copy', 'csv', 'excel', 'pdf', 'print'
            ],
            language: {
                searchPlaceholder: 'Search...',
                sSearch: '',
            },
        });
    });
</script>

<style>
    .dt-search{
        text-align: end;
    }
    table{
        margin-top: 20px !important;
    }

    .dt-paging.paging_full_numbers{
        text-align: end;
    }

    .dt-paging.paging_full_numbers button{
        margin: 0 2px;
        background-color: rgb(115, 93, 255);
        color: white;
        border: none;
        border-radius: 2rem;
        width: 2rem;
        height: 2rem;
    }





</style>

    
<?php include("code/footer.php"); ?>        

<!--**********************************
Main wrapper end
***********************************-->

<!--**********************************
Scripts
***********************************-->
<!-- Required vendors -->
<!-- <script src="vendor/global/global.min.js"></script>
<script src="vendor/jquery-nice-select/js/jquery.nice-select.min.js"></script>		
<script src="vendor/chart-js/chart.bundle.min.js"></script>

</script><script src="vendor/wnumb/wNumb.js"></script>
<script src="js/custom.min.js"></script>
<script src="js/dlabnav-init.js"></script> -->

</body>
</html>


