<!DOCTYPE html>
<html lang="kn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Receipt</title>
    <style>
        body {
            font-family: "Noto Sans Kannada", sans-serif;
        }
        .container {
            width: 95%;
            margin: auto;
            padding: 15px;
        }
        .header {
            text-align: center;
            font-weight: bold;
        }
        .info {
            margin-top: 10px;
            border-bottom: 1px solid black;
            padding-bottom: 10px;
        }
        .table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }
        .table th, .table td {
            border: 1px solid black;
            padding: 8px;
            text-align: center;
        }
        .table th {
            background-color: lightgray;
        }
        .amount {
            text-align: right;
            font-weight: bold;
        }
        .header-section,
        .footer-section {
            font-size: 20px;
        }

        span {
          font-weight: bold;
          text-transform: uppercase;
          text-decoration: underline;
        }

        .d-flex{
          display: flex;
        }

        .justify-content-between{
          justify-content: space-between;
        }

        .align-items-center{
          align-items: center;
        }


        .col-3{
          width: calc(25% - 6px);
          float: left;
        }

        .col-4{
          width: 33.33%;
          float: left;
        }

        .col-8{
          width: 66.66%;
          float: left;
        }

        .col-6{
          width: 50%;
          float: left;
        }

        .complete-underline{
          border-bottom: 2px solid black;
          font-weight: bolder;
        }


    </style>
</head>
<body>

<div class="container" id="printableArea">
  <div style="text-align: end;    margin-right: 22px;">
    ರೈತರಪ್ರತಿ/ರೇಷ್ಮೆಇಲಾಖೆ ಪ್ರತಿ
  </div>
  <div style="border:2px solid #000;padding: 30px; margin:20px">
      <div class="header-section">
          <div style="display: flex;justify-content: space-between;font-weight: 600;">
              <p style="font-size: smaller;">
                  ಪ್ರೊ.: ವಿನಯ್ ಹೆಚ್.ಗೌಡ
              </p>
              <p style="font-size: smaller;">
                  ನೋಂದಣಿ ಸಂ.: KA/01/RCR/05708/00553
              </p>
              <p style="font-size: smaller;">
                  Validity: 2027
              </p>
          </div>
          <div style="display: flex; flex-direction:column; justify-content: center; align-items: center;">
              <h2 style="margin: 10px 0px;font-size: larger;">ಕೀರಣಗೆರೆ ಹೈ-ಟೆಕ್ ಚಾಕಿ ಸಾಕಾಣಿಕಾ ಕೇ೦ದ್ರ (ರಿ.)</h2>
              <p style="margin: 0px;font-size: small;">ಕೀರಣಗೆರೆ,ಜಕ್ಕಸಂದ್ರ ಅಂಚೆ,ಹಾರೋಹಳ್ಳಿ ತಾಲ್ಲೂಕು - 562112</p>
              <p style="margin: 0px;font-size: small;">ಫೋನ್: 9008813867, 9986921627, 8088028748</p>
          </div>
      </div>

      <h4 style="text-align: center;margin:25px 0px 15px;font-size: larger;text-decoration: underline;">
          ನಗದು ರಸೀದಿ
      </h4>

      <div>
          <div class="d-flex justify-content-between" style="padding-bottom: 10px;">
              <div class="col-6 d-flex align-items-center">
                  <div class="col-6">
                    ರಸೀದಿ ಸಂಖ್ಯೆ
                  </div>
                  <div class="col-6 complete-underline">
                      : <?= $invoice_number ?>
                  </div>
              </div>
              <div class="col-6 d-flex align-items-center" style="padding-left: 20px" >
                  <div>
                    ದಿನಾಂಕ
                  </div>
                  <div class="complete-underline col-8">
                      :<?= date('d-m-Y' ,strtotime($ORDER['order_date'])) ?>
                  </div>
              </div>
          </div>
          <div class="d-flex" style="padding-bottom: 10px;">
              <div class="col-3 d-flex align-items-center">
                ರೈತರ ಹೆಸರು
              </div>
              <div class="col-8 complete-underline">
                  : <?= $FARMER['farmer_name'] ?>
              </div>
          </div>
          <div style="display:flex; justify-content:space-between;padding-bottom: 10px;">
              <div class="col-6 d-flex align-items-center">
                  <div class="col-6">
                      ತ೦ದೆ/ಗಂಡನ ಹೆಸರು
                  </div>
                  <div class="col-6 complete-underline">
                      :<?= $FARMER['farmer_fathername'] ?>
                  </div>
              </div>

              <div class="col-6 d-flex align-items-center" style="padding-left: 20px" >
                  <div>
                      ಪೋನ್
                  </div>
                  <div class="complete-underline col-8">
                      :<?= $FARMER['phone'] ?>
                  </div>
              </div>
          </div>

          <div style="display:flex; justify-content:space-between;padding-bottom: 10px;">
              <div class="col-6 d-flex align-items-center">
                  <div style="width: calc(50% - 6px);">
                      ವಿಳಾಸ
                  </div>
                  <div class="col-6 complete-underline">
                      :<?= $FARMER['village_name'] ?>
                  </div>
              </div>
          </div>
          <div style="display:flex; justify-content:space-between;padding-bottom: 10px;">
              <div class="col-6 d-flex align-items-center">
                  <div style="width: calc(50% - 6px);">
                      ತಾ.ಸೇ.ಕೇ
                  </div>
                  <div class="col-6 complete-underline">
                      :<?= $FARMER['survey_center'] ?>
                  </div>
              </div>

              <div class="col-6 d-flex align-items-center" style="padding-left: 20px" >
                  <div>
                      GST NO
                  </div>
                  <div class="complete-underline col-8">
                      : 29AJFPV2534GIZZ
                  </div>
              </div>

          </div>
      </div>

      <table class="table">
          <tr>
            <th>ಕ್ರ.ಸಂ.</th>
            <th>ವಿವರ</th>
            <th>ದರ</th>
            <th>ಮೊತ್ತ</th>
          </tr>
          <tr>
            <td>1</td>
            <td>ಮೊಟ್ಟೆಗಳ ಸಂಖ್ಯೆ</td>
            <td><?= $ORDER['order_quantity'] ?></td>
            <td>
                ₹<?= $ORDER['order_quantity'] * $price ?>
            </td>
          </tr>
          <tr>
            <td>2</td>
            <td>ಮರು ವಿತರಣಾ ಮೊಟ್ಟೆ</td>
            <td>
                <?= $bonus ?>
            </td>
            <td>
                -₹<?= $bonus * $price ?>
            </td>
          </tr>
          <tr>
            <td>3</td>
            <td>ತಳಿ</td>
            <td><?= $race ?></td>
            <td></td>
          </tr>
          <tr>
            <td>4</td>
            <td>ತಂಡ</td>
            <td>
              <?= $lot_number ?>
            </td>
            <td></td>
          </tr>
          <tr>
            <td>5</td>
            <td>
              ಮೂಲ
            </td>
            <td>
              <?= $souce ?>
            </td>
            <td></td>
          </tr>
          <tr>
            <td>6</td>
            <td>ಚಾಕಿ ದಿನಾ೦ಕ</td>
            <td>
              <?= date('d-m-Y', strtotime($DATA['hatchingdate'])) ?>
            </td>
            <td></td>
          </tr>
          <tr>
            <td>7</td>
            <td>ಹುಳು ವಿತರಣಾ ದಿನಾಂಕ</td>
            <td>
              <?= date('d-m-Y', strtotime($ORDER['order_date'])) ?>
            </td>
            <td></td>
          </tr>
          <tr>
            <td>8</td>
            <td>100ಕ್ಕೆ ಧರ</td>
            <td>
              ₹<?= ($price * 100)  ?>
            </td>
            <td>
              
            </td>
          </tr>
              
      </table>

      <p class="amount" style="padding-right: 10px;">ಒಟ್ಟು ಮೊತ್ತ: 
        <b style="padding-left: 10px;">
          ₹<?= ($price * ($ORDER['order_quantity']- $bonus))  ?>
        </b>
      </p>

      <p style="text-align: right; padding-right: 50px;padding-top:30px;font-weight:bolder;margin-top:200px">ಸಹಿ</p>
    </div>
</div>

</body>


<button onclick="printDiv('printableArea')">
    Print
</button>
</body>

<script>
    function printDiv(divName) {
        var printContents = document.getElementById(divName).innerHTML;
        var originalContents = document.body.innerHTML;

        document.body.innerHTML = printContents;

        window.print();

        document.body.innerHTML = originalContents;
    }
</script>
</html>
