<?php
include("code/config.php");

?>
<!DOCTYPE html>
<html lang="en">


<meta http-equiv="content-type" content="text/html;charset=UTF-8" />
<head>
    <?php include("code/meta.php") ?>
    <style>
        .aletrtErr {
            padding: 10px;
            border-radius: 10px;
            background: <?php if($err){ ?>var(--bs-danger)<?php }else{ ?>var(--bs-success)<?php } ?>;
            color: white;
        }

        .cpa{
            font-size: larger;
            font-weight: bold;

        }
    </style>

</head>
<body>
    <?php include("code/head.php") ?>
    <?php include("code/sidebar.php") ?>
    <?php include("modal/add-price.php") ?>

    <div class="main-content app-content">
        <div class="container-fluid">
            <div class="my-4 page-header-breadcrumb d-flex align-items-center justify-content-between flex-wrap gap-2">
                <div>
                    <h1 class="page-title fw-medium fs-18 mb-2">
                        <?php echo $TITLE; ?>
                    </h1>
                    <div class="">
                        <nav>
                            <ol class="breadcrumb mb-0">
                                <li class="breadcrumb-item"><a href="javascript:void(0);">Home</a></li>
                                <li class="breadcrumb-item active" aria-current="page"><?php echo $TITLE; ?></li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>

            <div class="mb-4">
                <?php if($msg){ ?><span class="aletrtErr"><?php echo $msg; ?></span><?php } ?>
                <span style="display:none;padding: 10px; border-radius: 10px; background: var(--bs-danger); color: white;" id="alert"></span>
            </div>

            <div class="d-flex justify-content-end">
                <div>
                    <button type="button" class="btn btn-primary mb-2" data-bs-toggle="modal"
                        data-bs-target="#exampleModalCenter">Add Price</button>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12 mb-4">
                    <div class="filter cm-content-box box-primary card p-3">
                        <div class="content-title">
                            <div class="cpa">
                                <i class="fa fa-file-lines me-1"></i>Price Details
                            </div>
                            <div class="tools">
                                <a href="javascript:void(0);" class="expand SlideToolHeader"><i
                                        class="fa fa-angle-down"></i></a>
                            </div>
                        </div>
                        <div class="cm-content-body form excerpt">
                            <div class="card-body pt-2">
                                <div class="table-responsive">
                                    <table id="file-export" class="table table-striped table-bordered text-nowrap w-100" style="min-width: 845px" role="grid" aria-describedby="example_info">
                                        <thead>
                                            <tr>
                                                <th><strong>S/NO</strong></th>
                                                <th><strong>Date</strong></th>
                                                <th><strong>Farmer Category</strong></th>
                                                <th><strong>Indent Type</strong></th>
                                                <th><strong>Price</strong></th>
                                                <th><strong>Actions</strong></th>
                                            </tr> 
                                        </thead>
                                        <tbody>
                                            <?php
                                                $i = 0;
                                                
                                                if(isset($price_fixation)){
                                                    foreach($price_fixation as $row){
                                            ?>
                                                <tr>
                                                    <td><?php echo ++$i; ?></td>
                                                    <td><?php echo $row['indent_date']; ?></td>
                                                    <td><?php echo $row['farmer_category']; ?></td>
                                                    <td><?php echo $row['indent_type']; ?></td>
                                                    <td><?php echo $row['price']; ?></td>
                                                    <td>
                                                        <form method="post" onsubmit="return confirm('are you sure? this action cannot be undone!')">
                                                            <input type="hidden" name="id" value="<?php echo $row['id']; ?>">
                                                            <input type="hidden" name="type" value="indent_price">
                                                            <button class="btn btn-danger shadow btn-xs sharp rounded-circle" name="del"><i class="fa fa-trash"></i></button>
                                                        </form>
                                                    </td>
                                                </tr>
                                            <?php
                                                    }}
                                            ?>
                                            
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                    
                
            </div>
        </div>
    </div>

    <script>
        $(document).ready(function () {
            $('#file-export').DataTable({
			pageLength: 100,
                dom: 'Bfrtip',
                buttons: [
                    'copy', 'csv', 'excel', 'pdf', 'print'
                ],
                language: {
                    searchPlaceholder: 'Search...',
                    sSearch: '',
                },
            });
        });
    </script>

    <style>
        .dt-search{
            text-align: end;
        }
        table{
            margin-top: 20px !important;
        }

        .dt-paging.paging_full_numbers{
            text-align: end;
        }

        .dt-paging.paging_full_numbers button{
            margin: 0 2px;
            background-color: rgb(115, 93, 255);
            color: white;
            border: none;
            border-radius: 2rem;
            width: 2rem;
            height: 2rem;
        }
    </style>

        
    <?php include("code/footer.php"); ?>        

</body>
</html>


