<?php
include("code/config.php");

?>
<!DOCTYPE html>
<html lang="en">


<meta http-equiv="content-type" content="text/html;charset=UTF-8" />
<head>
    <?php include("code/meta.php") ?>
    <style>
        .aletrtErr {
            padding: 10px;
            border-radius: 10px;
            background: <?php if($err){ ?>var(--bs-danger)<?php }else{ ?>var(--bs-success)<?php } ?>;
            color: white;
        }

        .cpa{
            font-size: larger;
            font-weight: bold;

        }
    </style>

</head>
<body>
    <?php include("code/head.php") ?>
    <?php include("code/sidebar.php") ?>

    <div class="main-content app-content">
        <div class="container-fluid">
            <div class="my-4 page-header-breadcrumb d-flex align-items-center justify-content-between flex-wrap gap-2">
                <div>
                    <h1 class="page-title fw-medium fs-18 mb-2">
                        <?php echo $TITLE; ?>
                    </h1>
                    <div class="">
                        <nav>
                            <ol class="breadcrumb mb-0">
                                <li class="breadcrumb-item"><a href="javascript:void(0);">Home</a></li>
                                <li class="breadcrumb-item active" aria-current="page"><?php echo $TITLE; ?></li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>

            <div class="mb-4">
                <?php if($msg){ ?><span class="aletrtErr"><?php echo $msg; ?></span><?php } ?>
                <span style="display:none;padding: 10px; border-radius: 10px; background: var(--bs-danger); color: white;" id="alert"></span>
            </div>
            

            <!-- Start:: row-4 -->
            <div class="row">
                <ul class="nav nav-pills justify-content-left mb-4 mx-4" role="tablist">
                    <li class=" nav-item" role="presentation">
                        <a href="#navpills2-1" class="nav-link active" data-bs-toggle="tab" aria-expanded="false" aria-selected="true" role="tab">CB Details</a>
                    </li>
                    <li class="nav-item" role="presentation">
                        <a href="#navpills2-2" class="nav-link" data-bs-toggle="tab" aria-expanded="false" aria-selected="false" role="tab" tabindex="-1">BV Details</a>
                    </li>
                </ul>
                <div class="tab-content">
                <div id="navpills2-1" class="tab-pane active show" role="tabpanel">
                            	<div class="row">
                            	    <div class="col-md-12 mb-4">
                            	        <div class="filter cm-content-box box-primary">
                            				<div class="content-title">
                            					<div class="cpa">
                            						<i class="fa fa-file-lines me-1"></i>CB Manual Order
                            					</div>
                            					<div class="tools">
                            						<a href="javascript:void(0);" class="expand SlideToolHeader"><i
                            								class="fa fa-angle-down"></i></a>
                            					</div>
                            				</div>
                            			</div>
                            			<div class="filter cm-content-box box-primary">
                            			    <div class="card-body pt-2">
                            			        <userOrders class="row col-md-12" id="farmerTableCb">
                                                    	        
                                                </userOrders>
                            			    </div>
                            			</div>
                            			<div class="filter cm-content-box box-primary">
                            				<div class="card p-3 cm-content-body form excerpt">
                            					<div class="card-body pt-2">
                            					    <userOrders class="row col-md-12" id="farmerTableCb">
                                                    	        
                                            	    </userOrders>
                            					    <form method="post">
                            					        <div class="row">
                                                    	    <div class="col-md-12 mb-4">
                                                    	        <label>Farmer</label>
                                                    	        <input class="form-control" onchange="getFarmerDetails(this.value,'cb');getFarmerOrders(this.value,'cb')" required list="farmre-list" name="farmer" id="farmer">

                                                                
                                                                <datalist id="farmre-list">
                                                                    <?php
                                                                        if($farmer_data_all){
                                                                            foreach($farmer_data_all as $row){
                                                                    ?>
                                                                                <option value="<?php echo $row['phone'] ?>"><?php echo $row['farmer_id'] ?> | <?php echo $row['farmer_name'] ?> | <?php echo $row['phone'] ?></option>
                                                                    <?php
                                                                            }
                                                                        }
                                                                    ?>
                                                                </datalist>
                                                    	    </div>	 
                                                    	    <FARMERDATA class="row col-md-12" id="farmerDataCb">
                                                    	        
                                                    	    </FARMERDATA>
                                                    	    
                                                            <div class="col-md-4 mb-2">
                                                                <label>
                                                                    Indent
                                                                </label>
                                                                <select name="indent" class="form-control" name="indent" onchange="getIndentData(this.value,'cb')" required>
                                                                    <option value=""></option>
                                                                    <?php
                                                                        $list = explode(",","Eggs,1st Moult,2nd Moult,3rd Moult");
                                                                    $i = 0 ;
                                                                        foreach($list as $l):
                                                                    ?>
                                                                            <option value="<?php echo $i; ?>"><?php echo $l; ?></option>
                                                                    <?php
                                                                            $i++;
                                                                        endforeach;
                                                                    ?>
                                                                </select>
                                                            </div>
                                                            <div class="col-md-4 mb-2">
                                                                <label>
                                                                    Available Date
                                                                </label>
                                                                <select name="avaDate" class="form-control" id="cbAvl" required>
                                                                    <option value=""></option>
                                                                </select>
                                                            </div>
                                                            <div class="col-md-4 mb-2">
                                                                <label>
                                                                    Quantity
                                                                </label>
                                                                <input type="number" step="0.01" name="qty" class="form-control" required>
                                                            </div>
                                                            
                                                            <input type="hidden" name="data" class="form-control" value="cb_data">
                                                            <input type="hidden" name="db" class="form-control" value="cb_orders">
                                                    	    <div class="col-md-12 mt-3">
                                                    	        <button class="btn btn-primary" name="NewOrder">Submit</button>
                                                    	    </div>
                                                    	</div>
                            					    </form>
                            					</div>
                            				</div>
                            			</div>
                            	    </div>
                            	</div>
    						</div>
    						<div id="navpills2-2" class="tab-pane" role="tabpanel">
                            	<div class="row">
                            	    <div class="col-md-12 mb-4">
                            	        <div class="filter cm-content-box box-primary">
                            				<div class="content-title">
                            					<div class="cpa">
                            						<i class="fa fa-file-lines me-1"></i>BV Manual Order
                            					</div>
                            					<div class="tools">
                            						<a href="javascript:void(0);" class="expand SlideToolHeader"><i
                            								class="fa fa-angle-down"></i></a>
                            					</div>
                            				</div>
                            			</div>
                            			<div class="filter cm-content-box box-primary">
                            			    <div class="card-body pt-2">
                            			        <userOrders class="row col-md-12" id="farmerTableBv">
                                                    	        
                                                </userOrders>
                            			    </div>
                            			</div>
                            			<div class="filter cm-content-box box-primary">
                            				<div class="card p-3 form excerpt">
                            					<div class="card-body pt-2">
                            						 <form method="post">
                            						     <div class="row">
                                                    	    <div class="col-md-12 mb-4">
                                                    	        <label>Farmer</label>
                                                    	        <input class="form-control" onchange="getFarmerDetails(this.value,'bv');getFarmerOrders(this.value,'bv')" required list="farmre-list" name="farmer" id="farmer">
                                                    	    </div>	 
                                                    	    <FARMERDATA class="row col-md-12" id="farmerDataBv">
                                                    	        
                                                    	    </FARMERDATA>
                                                    	    
                                                            <div class="col-md-4 mb-2">
                                                                <label>
                                                                    Indent
                                                                </label>
                                                                <select name="indent" class="form-control" onchange="getIndentData(this.value,'bv')" required>
                                                                    <option value=""></option>
                                                                    <?php
                                                                        $list = explode(",","Eggs,1st Moult,2nd Moult,3rd Moult");
                                                                    $i = 0 ;
                                                                        foreach($list as $l):
                                                                    ?>
                                                                            <option value="<?php echo $i; ?>"><?php echo $l; ?></option>
                                                                    <?php
                                                                            $i++;
                                                                        endforeach;
                                                                    ?>
                                                                </select>
                                                            </div>
                                                            <div class="col-md-4 mb-2">
                                                                <label>
                                                                    Available Date
                                                                </label>
                                                                <select name="avaDate" class="form-control" id="bvAvl" required>
                                                                    <option value=""></option>
                                                                </select>
                                                            </div>
                                                            <div class="col-md-4 mb-2">
                                                                <label>
                                                                    Quantity
                                                                </label>
                                                                <input type="number" step="0.01" name="qty" class="form-control" required>
                                                            </div>
                                                            
                                                            <input type="hidden" name="data" class="form-control" value="bv_data">
                                                            <input type="hidden" name="db" class="form-control" value="bv_orders">
                                                    	    <div class="col-md-12 mt-3">
                                                    	        <button class="btn btn-primary" name="NewOrder">Submit</button>
                                                    	    </div>
                                                    	</div>
                            						 </form>
                            					</div>
                            				</div>
                            			</div>
                            	    </div>
                            	</div>
    						</div>
    
                </div>
            </div>
        </div>
    </div>



    <script>
       function getFarmerDetails(e,y){
           var u = window.location.hostname;
           
           $.ajax({
            url:"api/getFarmerDetails?phone="+e,    //the page containing php script
            type: "get",    //request type
            success:function(result){
                if(result == 0){
                    document.getElementById('alert').style.display="";
                    document.getElementById('alert').innerHTML = 'Details Not Found!';
                        document.getElementById('farmerDataCb').innerHTML = "";
                        document.getElementById('farmerDataBv').innerHTML = "";
                }else{
                    document.getElementById('alert').style.display="none";
                    console.log(result,y);
                    if(y == "cb"){
                        document.getElementById('farmerDataCb').innerHTML = result.html;
                    }else{
                        document.getElementById('farmerDataBv').innerHTML = result.html;
                    }
                }
            }
        });
       }
       
       function getFarmerOrders(e,y){
           var u = window.location.hostname;
           
           $.ajax({
            url:"api/getFarmerOrders?phone="+e+"&db="+y,    //the page containing php script
            type: "get",    //request type
            success:function(result){
                if(result == 0){
                    document.getElementById('alert').style.display="";
                    document.getElementById('alert').innerHTML = 'Order history Not Found!';
                    document.getElementById('farmerTableCb').innerHTML = "";
                    document.getElementById('farmerTableBv').innerHTML = "";
                }else{
                    document.getElementById('alert').style.display="none";
                    if(y == "cb"){
                        document.getElementById('farmerTableCb').innerHTML = result;
                    }else{
                        document.getElementById('farmerTableBv').innerHTML = result;
                    }
                    loadTable(y);
                }
            }
        });
       }
       
       function getIndentData(e,y){
           document.getElementById('alert').style.display="none";
           var u = window.location.hostname;
           
           $.ajax({
            url:"api/getIndentDetails?id="+e+"&type="+y,    //the page containing php script
            type: "get",    //request type
            success:function(result){
                if(result == 0){
                    document.getElementById('alert').style.display="";
                    document.getElementById('alert').innerHTML = 'Date not available for given Indent.';
                    if(y == "cb"){
                        document.getElementById('cbAvl').innerHTML = "";
                    }else{
                        document.getElementById('bvAvl').innerHTML = "";
                    }
                }else{
                    if(y == "cb"){
                        document.getElementById('cbAvl').innerHTML = result.html;
                    }else{
                        document.getElementById('bvAvl').innerHTML = result.html;
                    }
                }
            }
        });
       }
       
       function loadTable(e){
           $(document).ready(function() { 
                $('#example'+e).DataTable( {
                    "pageLength": 5,
                    buttons: ['copy', 'csv', 'excel', 'pdf', 'print'],
                    layout: {
                        topStart: 'buttons'
                    }
                } );
                
            });
       }
   </script>
      


    <script>

        

        $(document).ready(function () {
            $('#file-export').DataTable({
			pageLength: 100,
                dom: 'Bfrtip',
                buttons: [
                    'copy', 'csv', 'excel', 'pdf', 'print'
                ],
                language: {
                    searchPlaceholder: 'Search...',
                    sSearch: '',
                },
            });
        });
    </script>

    <style>
        .dt-search{
            text-align: end;
        }
        table{
            margin-top: 20px !important;
        }

        .dt-paging.paging_full_numbers{
            text-align: end;
        }

        .dt-paging.paging_full_numbers button{
            margin: 0 2px;
            background-color: rgb(115, 93, 255);
            color: white;
            border: none;
            border-radius: 2rem;
            width: 2rem;
            height: 2rem;
        }





    </style>

        
    <?php include("code/footer.php"); ?>        

<!--**********************************
Main wrapper end
***********************************-->

<!--**********************************
Scripts
***********************************-->
<!-- Required vendors -->
<!-- <script src="vendor/global/global.min.js"></script>
<script src="vendor/jquery-nice-select/js/jquery.nice-select.min.js"></script>		
<script src="vendor/chart-js/chart.bundle.min.js"></script>

</script><script src="vendor/wnumb/wNumb.js"></script>
<script src="js/custom.min.js"></script>
<script src="js/dlabnav-init.js"></script> -->

</body>
</html>


