<?php
include("code/config.php");

?>
<!DOCTYPE html>
<html lang="en">


<meta http-equiv="content-type" content="text/html;charset=UTF-8" />
<head>
    <?php include("code/meta.php") ?>
    <style>
        .aletrtErr {
            padding: 10px;
            border-radius: 10px;
            background: <?php if($err){ ?>var(--bs-danger)<?php }else{ ?>var(--bs-success)<?php } ?>;
            color: white;
        }
    </style>

</head>
<body>
        <?php include("code/head.php") ?>
        <?php include("code/sidebar.php") ?>
        
        
        <!--**********************************
            Content body start
        ***********************************-->
					
		<div class="main-content app-content">
            <div class="container-fluid">

                <!-- Page Header -->
                <div class="my-4 page-header-breadcrumb d-flex align-items-center justify-content-between flex-wrap gap-2">
                    <div>
                        <h1 class="page-title fw-medium fs-18 mb-2">
                            <?php echo $TITLE; ?>
                        </h1>
                        <div class="">
                            <nav>
                                <ol class="breadcrumb mb-0">
                                    <li class="breadcrumb-item"><a href="javascript:void(0);">Home</a></li>
                                    <li class="breadcrumb-item active" aria-current="page"><?php echo $TITLE; ?></li>
                                </ol>
                            </nav>
                        </div>
                    </div>
                </div>

                <div class="mb-4">
                    <?php if($msg){ ?><span class="aletrtErr"><?php echo $msg; ?></span><?php } ?>
                </div>
                

                <!-- Start:: row-4 -->
                <div class="row">
                    <ul class="nav nav-pills justify-content-left mb-4 mx-4" role="tablist">
                        <li class=" nav-item" role="presentation">
                            <a href="#navpills2-1" class="nav-link active" data-bs-toggle="tab" aria-expanded="false" aria-selected="true" role="tab">CB Details</a>
                        </li>
                        <li class="nav-item" role="presentation">
                            <a href="#navpills2-2" class="nav-link" data-bs-toggle="tab" aria-expanded="false" aria-selected="false" role="tab" tabindex="-1">BV Details</a>
                        </li>
                    </ul>
                    <div class="tab-content">
                        <div id="navpills2-1" class="tab-pane active show" role="tabpanel">
                            <div class="card mb-4 pt-2 ps-3 pb-2">
                        	    <form method="post">
                        	        <div class="row">
                            	        <div class="col-md-12">
                            	            <h4>Add CB</h4>
                            	        </div>
                            	        <div class="col-md-2">
                                            <label>
                                                Hatch Date
                                            </label>
                                            <input type="date" name="hatchDate" class="form-control" required>
                                        </div>
                                        <div class="col-md-2">
                                            <label>
                                                Dist Date
                                            </label>
                                            <input type="date" name="distDate" class="form-control" required>
                                        </div>
                                        <div class="col-md-2">
                                            <label>
                                                Quantity
                                            </label>
                                            <input type="number" step="0.01" name="qty" class="form-control" required>
                                        </div>
                                        <div class="col-md-2">
                                            <label>
                                                Indent
                                            </label>
                                            <select name="indent" class="form-control" required>
                                                <option value="">Select Indent</option>
                                                <?php
                                                    $list = explode(",","Eggs,1st Moult,2nd Moult,3rd Moult");
                                                $i = 0 ;
                                                    foreach($list as $l):
                                                ?>
                                                        <option value="<?php echo $i; ?>"><?php echo $l; ?></option>
                                                <?php
                                                        $i++;
                                                    endforeach;
                                                ?>
                                            </select>
                                        </div>
                                        <div class="col-md-2">
                                            <label>
                                                Lot No
                                            </label>
                                            <input type="text" name="lot" class="form-control" required>
                                        </div>
                                        <div class="col-md-2">
                                            <button class="btn btn-primary" style="margin-top:26px" name="newCb">Submit</button>
                                        </div>
                            	    </div>
                        	    </form>
                        	</div>
                            <div class="col-xl-12">
                                <div class="card custom-card">
                                    <div class="card-header">
                                        <div class="card-title">CB Orders List</div>
                                    </div>
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table id="file-export" class="table table-bordered text-nowrap w-100">
                                                <thead>
                                                    <tr>
                                                        <th><strong>S/NO</strong></th>
                                                        
                                                        <th><strong>Lot No</strong></th>
                                                        <th><strong>Total Quantity</strong></th>
                                                        <th><strong>Available Quantity</strong></th>
                                                        <th><strong>Hatch Date</strong></th>
                                                        <th><strong>Dist Date</strong></th>
                                                        <th><strong>Moult</strong></th>
                                                        
                                                        <th style="width:85px;"><strong>Actions</strong></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php
                                                        $i = 0 ;
                                                        if(!empty($cb_data)){
                                                            foreach($cb_data as $row){
                                             
                                                    ?>
                                                    
                                                                <tr>
                                                                    <td><?php echo ++$i; ?></td>
                                                                    <td><?php echo $row['lot_number']; ?></td>
                                                                    <td><?php echo $row['totalQuantity']; ?></td>
                                                                    <td><?php echo $row['quantity']; ?></td>
                                                                    <td><?php echo date("d/m/Y",strtotime($row['hatchingdate'])); ?></td>
                                                                    <td><?php echo date("d/m/Y",strtotime($row['availabledata'])); ?></td>
                                                                    <td><?php echo $row['indent_moult']; ?> <?php if(strtotime(date("Y-m-d")) > strtotime($row['availabledata'])): echo '(EXPIRED)'; else: $datediff = strtotime($row['availabledata']) - strtotime(date("Y-m-d")); echo '('.round($datediff / (60 * 60 * 24)).' Day)'; endif; ?></td>
                                                                    <td>
                                                                        <form method="post" onsubmit="return confirm('are you sure? this action cannot be undone!')">
                                                                            <input type="hidden" name="id" value="<?php echo $row['id']; ?>">
                                                                            <input type="hidden" name="type" value="cb_data">
                                                                            <button class="btn btn-danger shadow btn-xs sharp rounded-circle p-2" name="del">
                                                                                <svg fill="#ffffff" width="15px" height="15px" viewBox="-7.29 0 122.88 122.88" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" style="enable-background:new 0 0 108.29 122.88" xml:space="preserve" stroke="#ffffff"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <g> <path d="M77.4,49.1h-5.94v56.09h5.94V49.1L77.4,49.1L77.4,49.1z M6.06,9.06h32.16V6.2c0-0.1,0-0.19,0.01-0.29 c0.13-2.85,2.22-5.25,5.01-5.79C43.97-0.02,44.64,0,45.38,0H63.9c0.25,0,0.49-0.01,0.73,0.02c1.58,0.08,3.02,0.76,4.06,1.81 c1.03,1.03,1.69,2.43,1.79,3.98c0.01,0.18,0.02,0.37,0.02,0.55v2.7H103c0.44,0,0.75,0.01,1.19,0.08c2.21,0.36,3.88,2.13,4.07,4.37 c0.02,0.24,0.03,0.47,0.03,0.71v10.54c0,1.47-1.19,2.66-2.67,2.66H2.67C1.19,27.43,0,26.23,0,24.76V24.7v-9.91 C0,10.64,2.04,9.06,6.06,9.06L6.06,9.06z M58.07,49.1h-5.95v56.09h5.95V49.1L58.07,49.1L58.07,49.1z M38.74,49.1H32.8v56.09h5.95 V49.1L38.74,49.1L38.74,49.1z M10.74,31.57h87.09c0.36,0.02,0.66,0.04,1.03,0.1c1.25,0.21,2.4,0.81,3.27,1.66 c1.01,1,1.67,2.34,1.7,3.83c0,0.31-0.03,0.63-0.06,0.95l-7.33,78.66c-0.1,1.03-0.27,1.95-0.79,2.92c-1.01,1.88-2.88,3.19-5.2,3.19 H18.4c-0.55,0-1.05,0-1.59-0.08c-0.22-0.03-0.43-0.08-0.64-0.14c-0.31-0.09-0.62-0.21-0.91-0.35c-0.27-0.13-0.52-0.27-0.78-0.45 c-1.51-1.04-2.51-2.78-2.69-4.72L4.5,37.88c-0.02-0.25-0.04-0.52-0.04-0.77c0.05-1.48,0.7-2.8,1.7-3.79 c0.88-0.86,2.06-1.47,3.33-1.67C9.9,31.59,10.34,31.57,10.74,31.57L10.74,31.57z M97.75,36.9H10.6c-0.57,0-0.84,0.1-0.79,0.7 l7.27,79.05h0l0,0.01c0.03,0.38,0.2,0.69,0.45,0.83l0,0l0.08,0.03l0.06,0.01l0.08,0h72.69c0.6,0,0.67-0.84,0.71-1.28l7.34-78.71 C98.53,37.04,98.23,36.9,97.75,36.9L97.75,36.9z"></path> </g> </g></svg>
                                                                            </button>
                                                                        </form>
                                                                    </td>
                                                                </tr>
                                                    <?php
                                                        }
                                                    }
                                                    ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div id="navpills2-2" class="tab-pane show" role="tabpanel">
                            <div class="card mb-4 pt-2 ps-3 pb-2">
                        	    <form method="post">
                        	        <div class="row">
                            	        <div class="col-md-12">
                            	            <h4>Add BV</h4>
                            	        </div>
                            	        <div class="col-md-2">
                                            <label>
                                                Hatch Date
                                            </label>
                                            <input type="date" name="hatchDate" class="form-control" required>
                                        </div>
                                        <div class="col-md-2">
                                            <label>
                                                Distribution Date
                                            </label>
                                            <input type="date" name="distDate" class="form-control" required>
                                        </div>
                                        <div class="col-md-2">
                                            <label>
                                                Quantity
                                            </label>
                                            <input type="number" step="0.01" name="qty" class="form-control" required>
                                        </div>
                                        <div class="col-md-2">
                                            <label>
                                                Indent
                                            </label>
                                            <select name="indent" class="form-control" required>
                                                <option value="">Select Indent</option>
                                                <?php
                                                    $list = explode(",","Eggs,1st Moult,2nd Moult,3rd Moult");
                                                $i = 0 ;
                                                    foreach($list as $l):
                                                ?>
                                                        <option value="<?php echo $i; ?>"><?php echo $l; ?></option>
                                                <?php
                                                        $i++;
                                                    endforeach;
                                                ?>
                                            </select>
                                        </div>
                                        <div class="col-md-2">
                                            <label>
                                                Lot No
                                            </label>
                                            <input type="text" name="lot" class="form-control" required>
                                        </div>
                                        <div class="col-md-2">
                                            <button class="btn btn-primary" style="margin-top:26px" name="newBv">Submit</button>
                                        </div>
                            	    </div>
                        	    </form>
                        	</div>
                            <div class="col-xl-12 filter cm-content-box">
                                <div class="card custom-card cm-content-body form excerpt">
                                    <div class="card-header">
                                        <div class="card-title">BV Orders List</div>
                                    </div>
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table id="file-export-1" class="table table-striped table-bordered text-nowrap w-100" style="min-width: 845px" role="grid" aria-describedby="example_info">
                                                <thead>
                                                    <tr>
                                                        <th><strong>S/NO</strong></th>
                                                        
                                                        <th><strong>Lot No</strong></th>
                                                        <th><strong>Total Quantity</strong></th>
                                                        <th><strong>Available Quantity</strong></th>
                                                        <th><strong>Hatch Date</strong></th>
                                                        <th><strong>Distribution Date</strong></th>
                                                        <th><strong>Moult</strong></th>
                                                        
                                                        <th style="width:85px;"><strong>Actions</strong></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php
                                                        $i = 0;
                                                        if(!empty($bv_data)){
                                                            foreach($bv_data as $row){
                                                    ?>
                                                    
                                                                <tr>
                                                                    <td><?php echo ++$i; ?></td>
                                                                    <td><?php echo $row['lot_number']; ?></td>
                                                                    <td><?php echo $row['totalQuantity']; ?></td>
                                                                    <td><?php echo $row['quantity']; ?></td>
                                                                    <td><?php echo date("d/m/Y",strtotime($row['hatchingdate'])); ?></td>
                                                                    <td><?php echo date("d/m/Y",strtotime($row['availabledata'])); ?></td>
                                                                    <td><?php echo $row['indent_moult']; ?> <?php if(strtotime(date("Y-m-d")) > strtotime($row['availabledata'])): echo '(EXPIRED)'; else: $datediff = strtotime($row['availabledata']) - strtotime(date("Y-m-d")); echo '('.round($datediff / (60 * 60 * 24)).' Day)'; endif; ?></td>
                                                                    <td>
                                                                        <form method="post" onsubmit="return confirm('are you sure? this action cannot be undone!')">
                                                                            <input type="hidden" name="id" value="<?php echo $row['id']; ?>">
                                                                            <input type="hidden" name="type" value="bv_data">
                                                                            <button class="btn btn-danger shadow btn-xs sharp rounded-circle p-2" name="del">
                                                                                <svg fill="#ffffff" width="15px" height="15px" viewBox="-7.29 0 122.88 122.88" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" style="enable-background:new 0 0 108.29 122.88" xml:space="preserve" stroke="#ffffff"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <g> <path d="M77.4,49.1h-5.94v56.09h5.94V49.1L77.4,49.1L77.4,49.1z M6.06,9.06h32.16V6.2c0-0.1,0-0.19,0.01-0.29 c0.13-2.85,2.22-5.25,5.01-5.79C43.97-0.02,44.64,0,45.38,0H63.9c0.25,0,0.49-0.01,0.73,0.02c1.58,0.08,3.02,0.76,4.06,1.81 c1.03,1.03,1.69,2.43,1.79,3.98c0.01,0.18,0.02,0.37,0.02,0.55v2.7H103c0.44,0,0.75,0.01,1.19,0.08c2.21,0.36,3.88,2.13,4.07,4.37 c0.02,0.24,0.03,0.47,0.03,0.71v10.54c0,1.47-1.19,2.66-2.67,2.66H2.67C1.19,27.43,0,26.23,0,24.76V24.7v-9.91 C0,10.64,2.04,9.06,6.06,9.06L6.06,9.06z M58.07,49.1h-5.95v56.09h5.95V49.1L58.07,49.1L58.07,49.1z M38.74,49.1H32.8v56.09h5.95 V49.1L38.74,49.1L38.74,49.1z M10.74,31.57h87.09c0.36,0.02,0.66,0.04,1.03,0.1c1.25,0.21,2.4,0.81,3.27,1.66 c1.01,1,1.67,2.34,1.7,3.83c0,0.31-0.03,0.63-0.06,0.95l-7.33,78.66c-0.1,1.03-0.27,1.95-0.79,2.92c-1.01,1.88-2.88,3.19-5.2,3.19 H18.4c-0.55,0-1.05,0-1.59-0.08c-0.22-0.03-0.43-0.08-0.64-0.14c-0.31-0.09-0.62-0.21-0.91-0.35c-0.27-0.13-0.52-0.27-0.78-0.45 c-1.51-1.04-2.51-2.78-2.69-4.72L4.5,37.88c-0.02-0.25-0.04-0.52-0.04-0.77c0.05-1.48,0.7-2.8,1.7-3.79 c0.88-0.86,2.06-1.47,3.33-1.67C9.9,31.59,10.34,31.57,10.74,31.57L10.74,31.57z M97.75,36.9H10.6c-0.57,0-0.84,0.1-0.79,0.7 l7.27,79.05h0l0,0.01c0.03,0.38,0.2,0.69,0.45,0.83l0,0l0.08,0.03l0.06,0.01l0.08,0h72.69c0.6,0,0.67-0.84,0.71-1.28l7.34-78.71 C98.53,37.04,98.23,36.9,97.75,36.9L97.75,36.9z"></path> </g> </g></svg>
                                                                            </button>
                                                                        </form>
                                                                    </td>
                                                                </tr>
                                                    <?php
                                                            }
                                                        }
                                                    ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>     
                </div>
                <!-- End:: row-4 -->


            </div>
        </div> 
        <!--**********************************
            Content body end
        ***********************************-->

        <!--**********************************
            Footer start
        ***********************************-->


        <script>

        

        $(document).ready(function () {
            $('#file-export').DataTable({
			pageLength: 100,
                dom: 'Bfrtip',
                buttons: [
                    'copy', 'csv', 'excel', 'pdf', 'print'
                ],
                language: {
                    searchPlaceholder: 'Search...',
                    sSearch: '',
                },
            });
            $('#file-export-1').DataTable({
                dom: 'Bfrtip',
                buttons: [
                    'copy', 'csv', 'excel', 'pdf', 'print'
                ],
                language: {
                    searchPlaceholder: 'Search...',
                    sSearch: '',
                },
            });
        });
        </script>

        <style>
            .dt-search{
                text-align: end;
            }
            table{
                margin-top: 20px !important;
            }

            .dt-paging.paging_full_numbers{
                text-align: end;
            }

            .dt-paging.paging_full_numbers button{
                margin: 0 2px;
                background-color: rgb(115, 93, 255);
                color: white;
                border: none;
                border-radius: 2rem;
                width: 2rem;
                height: 2rem;
            }





        </style>

			
		<?php include("code/footer.php"); ?>        

    </div>
    <!--**********************************
        Main wrapper end
    ***********************************-->

    <!--**********************************
        Scripts
    ***********************************-->
    <!-- Required vendors -->
	<!-- <script src="vendor/global/global.min.js"></script>
    <script src="vendor/jquery-nice-select/js/jquery.nice-select.min.js"></script>		
	<script src="vendor/chart-js/chart.bundle.min.js"></script>

	</script><script src="vendor/wnumb/wNumb.js"></script>
	<script src="js/custom.min.js"></script>
	<script src="js/dlabnav-init.js"></script> -->

    <script src="https://cdn.datatables.net/v/dt/dt-2.0.3/datatables.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/3.0.1/js/dataTables.buttons.js"></script>
    <script src="https://cdn.datatables.net/buttons/3.0.1/js/buttons.dataTables.js"></script>
    <script src="https://cdn.datatables.net/buttons/3.0.1/js/buttons.colVis.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/3.0.1/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/3.0.1/js/buttons.print.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
</body>
</html>