<?php
include("code/config.php");

?>
<!DOCTYPE html>
<html lang="en">


<meta http-equiv="content-type" content="text/html;charset=UTF-8" />
<head>
    <?php include("code/meta.php") ?>
    <style>
        .aletrtErr {
            padding: 10px;
            border-radius: 10px;
            background: <?php if($err){ ?>var(--bs-danger)<?php }else{ ?>var(--bs-success)<?php } ?>;
            color: white;
        }

        .cpa{
            font-size: larger;
            font-weight: bold;

        }
    </style>

</head>
<body>
    <?php include("code/head.php") ?>
    <?php include("code/sidebar.php") ?>
    <?php include("modal/complaint-reply.php") ?>

    <div class="main-content app-content">
        <div class="container-fluid">
            <div class="my-4 page-header-breadcrumb d-flex align-items-center justify-content-between flex-wrap gap-2">
                <div>
                    <h1 class="page-title fw-medium fs-18 mb-2">
                        <?php echo $TITLE; ?>
                    </h1>
                    <div class="">
                        <nav>
                            <ol class="breadcrumb mb-0">
                                <li class="breadcrumb-item"><a href="javascript:void(0);">Home</a></li>
                                <li class="breadcrumb-item active" aria-current="page"><?php echo $TITLE; ?></li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>

            <div class="mb-4">
                <?php if($msg){ ?><span class="aletrtErr"><?php echo $msg; ?></span><?php } ?>
                <span style="display:none;padding: 10px; border-radius: 10px; background: var(--bs-danger); color: white;" id="alert"></span>
            </div>

            <div class="row">
                <div class="col-md-12 mb-4">
                    <div class="filter cm-content-box box-primary">
                        <div class="content-title">
                            <div class="cpa">
                                <i class="fa fa-file-lines me-1"></i>Complaint List
                            </div>
                            <div class="tools">
                                <a href="javascript:void(0);" class="expand SlideToolHeader"><i
                                        class="fa fa-angle-down"></i></a>
                            </div>
                        </div>
                        <div class="cm-content-body form excerpt">
                            <div class="card-body pt-2">
                                <div class="table-responsive">
                                    <table id="example" class="table table-striped table-bordered text-nowrap w-100" style="min-width: 845px" role="grid" aria-describedby="example_info">
                                        <thead>
                                            <tr>
                                                <th><strong>S/NO</strong></th>
                                                <th><strong>Farmer Id</strong></th>
                                                <th><strong>Farmer Phone</strong></th>
                                                <th><strong>Purchase Date</strong></th>
                                                <th><strong>Stage</strong></th>
                                                <th><strong>Message</strong></th>
                                                <th style="width:85px;"><strong>Action</strong></th>
                                            </tr> 
                                        </thead>
                                        <tbody>
                                            <?php
                                                
                                                $i = 0;
                                                
                                if(isset($complaints)){
                                                    foreach($complaints as $row){
                                            ?>
                                                        <tr>
                                                            <td><?php echo ++$i; ?></td>
                                                            <td><?php echo $row['farmer_id']; ?></td>
                                                            <td><?php echo $row['farmer_phone']; ?></td>
                                                            <td><?php echo date("d/m/Y",strtotime($row['purchase_date'])); ?></td>
                                                            <td><?php echo $row['stageoflarvae']; ?></td>
                                                            <td><?php echo $row['complaint']; ?></td>
                                                            <td>
                                                                <button onclick="updateId(<?php echo $row['id']; ?>)" type="button" class="btn btn-primary mb-2" data-bs-toggle="modal" data-bs-target="#exampleModalCenter">Reply</button>
                                                            </td>
                                                        </tr>
                                            <?php
                                                    }
                                                }
                                            ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>



        </div>
    </div>

    <script>
        $(document).ready(function () {
            $('#file-export').DataTable({
			pageLength: 100,
                dom: 'Bfrtip',
                buttons: [
                    'copy', 'csv', 'excel', 'pdf', 'print'
                ],
                language: {
                    searchPlaceholder: 'Search...',
                    sSearch: '',
                },
            });
        });
    </script>

    <style>
        .dt-search{
            text-align: end;
        }
        table{
            margin-top: 20px !important;
        }

        .dt-paging.paging_full_numbers{
            text-align: end;
        }

        .dt-paging.paging_full_numbers button{
            margin: 0 2px;
            background-color: rgb(115, 93, 255);
            color: white;
            border: none;
            border-radius: 2rem;
            width: 2rem;
            height: 2rem;
        }
    </style>

        
    <?php include("code/footer.php"); ?>        

</body>
</html>


