<?php
include("code/config.php");

?>
<!DOCTYPE html>
<html lang="en">


<meta http-equiv="content-type" content="text/html;charset=UTF-8" />
<head>
    <?php include("code/meta.php") ?>
    <style>
        .aletrtErr {
            padding: 10px;
            border-radius: 10px;
            background: <?php if($err){ ?>var(--bs-danger)<?php }else{ ?>var(--bs-success)<?php } ?>;
            color: white;
        }

        .cpa{
            font-size: larger;
            font-weight: bold;

        }
    </style>

</head>
<body>
    <?php include("code/head.php") ?>
    <?php include("code/sidebar.php") ?>



    <div class="main-content app-content">
        <div class="container-fluid">
            <div class="my-4 page-header-breadcrumb d-flex align-items-center justify-content-between flex-wrap gap-2">
                <div>
                    <h1 class="page-title fw-medium fs-18 mb-2">
                        <?php echo $TITLE; ?>
                    </h1>
                    <div class="">
                        <nav>
                            <ol class="breadcrumb mb-0">
                                <li class="breadcrumb-item"><a href="javascript:void(0);">Home</a></li>
                                <li class="breadcrumb-item active" aria-current="page"><?php echo $TITLE; ?></li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>

            <div class="mb-4">
                <?php if($msg){ ?><span class="aletrtErr"><?php echo $msg; ?></span><?php } ?>
                <span style="display:none;padding: 10px; border-radius: 10px; background: var(--bs-danger); color: white;" id="alert"></span>
            </div>

            <div class="row">
            <div class="container-fluid">
			    <div class="card-body">
    			    <div class="mb-4">
        		        <?php if($msg){ ?><span class="aletrtErr"><?php echo $msg; ?></span><?php } ?>
        		    </div>
					<ul class="nav nav-pills justify-content-left mb-4" role="tablist">
						<li class=" nav-item" role="presentation">
							<a href="cb-cancelled-orders" class="nav-link active" data-bs-toggle="" aria-expanded="false" aria-selected="true" role="">CB Orders</a>
						</li>
						<li class="nav-item" role="presentation">
							<a href="bv-cancelled-orders" class="nav-link " data-bs-toggle="" aria-expanded="false" aria-selected="false" role="" tabindex="-1">BV Orders</a>
						</li>
					</ul>
					<div class="tab-content">
					    
						<div id="navpills2-1" class="tab-pane active show" role="tabpanel">
						    
						    <ul class="nav nav-pills justify-content-left mb-4" role="tablist">
        						<li class=" nav-item" role="presentation">
        							<a href="cb-pending-orders" class="nav-link" data-bs-toggle="" aria-expanded="false" aria-selected="true" role="">Pending Orders</a>
        						</li>
        						<li class="nav-item" role="presentation">
        							<a href="cb-confirmed-orders" class="nav-link " data-bs-toggle="" aria-expanded="false" aria-selected="false" role="" tabindex="-1">Confirmed Orders</a>
        						</li>
        						<li class="nav-item" role="presentation">
        							<a href="cb-cancelled-orders" class="nav-link active" data-bs-toggle="" aria-expanded="false" aria-selected="false" role="" tabindex="-1">Cancelled Orders</a>
        						</li>
        						<li class="nav-item" role="presentation">
        							<a href="cb-distributed" class="nav-link" data-bs-toggle="" aria-expanded="false" aria-selected="false" role="" tabindex="-1">Distribution</a>
        						</li>
        					</ul>
        					<div class="tab-content">
 
        					     <div id="navpiwda2adwa-1" class="tab-pane active show" role="tabpanel">
        					        <div class="card mb-4 pt-2 ps-3 pb-2">
                                	    <form method="post">
                                	        <div class="row">
                                    	        <div class="col-md-3">
                                        	        <label>From Date</label>
                                        	        <input type="date" class="form-control" name="fromDate" value="<?php if(isset($_POST['fromDate']) and !$defaut) { echo $_POST['fromDate']; }else{ echo date("Y-m-d"); }  ?>">
                                        	    </div>
                                        	    <div class="col-md-3">
                                        	        <label>To Date</label>
                                        	        <input type="date" class="form-control" name="toDate" value="<?php if(isset($_POST['toDate']) and !$defaut) { echo $_POST['toDate']; }else{ echo date("Y-m-d"); }  ?>">
                                        	    </div>
                                        	    <div class="col-md-2">
                                        	        <label>Filter Date</label>
                                        	        <select class="form-control" name="dateType">
                                        	            <option value=""></option>
                                        	            <?php
                                                            $list = explode(",","Order Date,Distribution Date");
                                                                $i = 0;
                                                                
                                                            foreach($list as $l):
                                                        ?>
                                                                <option <?php if(isset($_POST['dateType']) and !$defaut) { if($_POST['dateType'] == $i)echo 'selected'; }else{ if($i==0)echo 'selected';}  ?> value="<?php echo $i; ?>"><?php echo $l; ?></option>
                                                        <?php
                                                                $i++;
                                                            endforeach;
                                                        ?>
                                        	        </select>
                                        	    </div>

                                        	    <div class="col-md-2">
                                        	        <label>Type</label>
                                        	        <select class="form-control" name="type">
                                        	            <?php
                                                            $list = explode(",","All,Farmers,Black Box Agents,Chawki Agents,Franchise,Admin");
                                                        
                                                            foreach($list as $l):
                                                        ?>
                                                                <option <?php if(isset($_POST['type'])) { if($_POST['type'] == $l)echo 'selected'; }elseif($l == "All"){ echo 'selected'; }  ?> ><?php echo $l; ?></option>
                                                        <?php
                                                            endforeach;
                                                        ?>
                                        	        </select>
                                        	    </div>
                                        	    <div class="col-md-2">
                                        	        <label>AM / PM</label>
                                        	        <select class="form-control" name="ampm">
                                        	            <?php
                                                            $list = explode(",","All,Am,Pm");
                                                        
                                                            foreach($list as $l):
                                                        ?>
                                                                <option <?php if(isset($_POST['type'])) { if($_POST['type'] == $l)echo 'selected'; }elseif($l == "All"){ echo 'selected'; }  ?> ><?php echo $l; ?></option>
                                                        <?php
                                                            endforeach;
                                                        ?>
                                        	        </select>
                                        	    </div>
                                        	    
                                        	    <div class="col-md-2">
                                        	        <button class="btn btn-primary" style="margin-top:26px" name="filterCb">Filter</button>
                                        	    </div>
                                    	    </div>
                                	    </form>
                                	</div>
                                	
                                	<?php
    							        
    							        $i = 0;
    							        $list = explode(",","Eggs,1st Moult,2nd Moult,3rd Moult");
                                        

								    ?>
                                	<div class="card mb-4 pt-4 ps-3 pe-3">
                                	    <div class="row">
                                	        <div class="col-md-6">
                                    			<div class="card bg-success invoice-card">
                                    				<div class="card-body d-flex">
                                    					<div class="icon me-3">
                                    						<i class="fa fa-user"></i>
                                    					</div>
                                    					<div>
                                    						<h2 class="text-white invoice-num"><?= $farmers_count ?></h2>
                                    						<span class="text-white fs-18">Total Farmers</span>
                                    					</div>
                                    				</div>
                                    			</div>
                                    		</div>
                                    		
                                    		<div class="col-md-6">
                                    			<div class="card bg-info invoice-card">
                                    				<div class="card-body d-flex">
                                    					<div class="icon me-3">
                                    						<i class="fa fa-cart-plus"></i>
                                    					</div>
                                    					<div>
                                    						<h2 class="text-white invoice-num"><?php $i=0; foreach($orders as $sum): $i += $sum['order_quantity']; endforeach;echo $i; ?></h2>
                                    						<span class="text-white fs-18">Number of DFLS</span>
                                    					</div>
                                    				</div>
                                    			</div>
                                    		</div>
                                    		
                                	    </div>
                                	</div>
                                	
                                	<div class="row">
                                	    <div class="col-md-12 mb-4">
                                	        <div class="filter cm-content-box box-primary">
                                				<div class="content-title">
                                					<div class="cpa">
                                						<i class="fa fa-file-lines me-1"></i>CB Orders List
                                					</div>
                                					<div class="tools">
                                						<a href="javascript:void(0);" class="expand SlideToolHeader"><i
                                								class="fa fa-angle-down"></i></a>
                                					</div>
                                				</div>
                                				<div class="cm-content-body form excerpt">
                                					<div class="card-body pt-2">
                                						<div class="table-responsive">
                                
                                							<table id="example" class="table table-striped table-bordered text-nowrap w-100" style="min-width: 845px" role="grid" aria-describedby="example_info">
                                								<thead>
                                									<tr>
                                										<th><strong>S/NO</strong></th>
                                										<th style="width:85px;"><strong>Reason</strong></th>
                                										<th><strong>Farmer Name</strong></th>
                                										<th><strong>Farmer Phone</strong></th>
                                										<th><strong>Father's Name</strong></th>
                                										<th><strong>Added By</strong></th>
                                										<th><strong>Cancelled By</strong></th>
                                										<th><strong>Village Name</strong></th>
<th><strong>District Name</strong></th>
<th><strong>Taluk Name</strong></th>
<th><strong>TSC</strong></th>
                                										<th><strong>Quantity</strong></th>
                                										<th><strong>Moult</strong></th>
                                										<th><strong>Dist Date</strong></th>
                                										<th><strong>AM / PM</strong></th>
                                										<th><strong>Order Date</strong></th>
                                										<th><strong>Status</strong></th>
                                									</tr> 
                                								</thead>
                                								<tbody>
                                								    <?php
                                								        if(isset($orders)){

                                                                            foreach($orders as $row){
                                								    ?>
                                								                <tr>
                                            										<td><?php echo ++$i; ?></td>
                                            										<td style="display: flex; gap: 10px;">
                                            										    <?php echo $row['cancel']; ?>
                                            										</td>
                                            										<td><?php echo $row['farmer_name']; ?></td>
                                            										<td><?php echo $row['farmer_phone']; ?></td>
                                            										<td><?php echo $row['farmer_fathername']; ?></td>
                                            										<td><?php echo $row['username'] ?></td>
                                            										<td><?php echo $row['username2'] ?></td>
                                            										<td><?php echo $row['village_name']; ?></td>
<td><?php echo $row['district_name']; ?></td>
<td><?php echo $row['taluk_name']; ?></td>
<td><?php echo $row['survey_center']; ?></td>
                                            										<td><?php echo $row['order_quantity']; ?></td>
                                            										<td><?php echo $list[$row['indent_moult']]; ?></td>
                                            										<td><?php echo date("d/m/Y",strtotime($row['order_date'])); ?></td>
                                            										<td><?= $row['ampm'] ?></td>
                                            										<td><?php echo  date("d/m/Y",strtotime($row['order_currect_date'])); ?></td>
                                            										<td><?php echo ucfirst($row['order_confirm']); ?></td>
                                            										
                                            									</tr>
                                								    <?php
                                                                            }
                                                                        }
                                								    ?>
                                								</tbody>
                                							</table>
                                						</div>
                                					</div>
                                				</div>
                                			</div>
                                	    </div>
                                	</div>
        					    </div>
        					    
        					    
        					 
        					    
        					</div>
        					
        					
						</div>
						
						
						</div>
				</div>
            </div>

                
            </div>
        
        </div>
    </div>



<script>

    

    $(document).ready(function () {
        $('#file-export').DataTable({
			pageLength: 100,
            dom: 'Bfrtip',
            buttons: [
                'copy', 'csv', 'excel', 'pdf', 'print'
            ],
            language: {
                searchPlaceholder: 'Search...',
                sSearch: '',
            },
        });
        $('#example').DataTable({
			pageLength: 100,
            dom: 'Bfrtip',
            buttons: [
                'copy', 'csv', 'excel', 'pdf', 'print'
            ],
            language: {
                searchPlaceholder: 'Search...',
                sSearch: '',
            },
        });
    });
</script>

<style>
    .dt-search{
        text-align: end;
    }
    table{
        margin-top: 20px !important;
    }

    .dt-paging.paging_full_numbers{
        text-align: end;
    }

    .dt-paging.paging_full_numbers button{
        margin: 0 2px;
        background-color: rgb(115, 93, 255);
        color: white;
        border: none;
        border-radius: 2rem;
        width: 2rem;
        height: 2rem;
    }





</style>

    
<?php include("code/footer.php"); ?>        



</body>
</html>


