<?php

namespace App\Controllers;

class DashboadController extends BaseController
{

    // add constructor and load the db

    public function __construct()
    {
        $session = session();

        $router = service('router');
        $currentMethod = $router->methodName();

        $excludedMethods = ['index', 'login', 'login_post'];

        if (
            !in_array($currentMethod, $excludedMethods) &&
            (!$session->get('id') || !$session->get('is_admin'))
        ) {
            redirect()->to('/admin/login')->send();
            exit;
        }
    }
    
    public function logout(){
        session()->destroy();
        $router = service('router');
        return redirect()->to('admin/login');
    }

    // API----------------------------


    public function getEditData() {
        if (!isset($_GET['id'])) {
            exit;
        }
        
        $db = \Config\Database::connect();
        $id = $_GET['id'];
        $sql = 'SELECT * FROM tbl_info WHERE id = ?';
        $query = $db->query($sql, [$id]);
        $result = $query->getResultArray();
        
        if (count($result) == 0) {
            echo 0;
            return;
        }
        
        $row = $result[0];
        
        $html = '<div class="row">';
        $html .= '<div class="col-md-6 mb-2">
                    <label>Full Name</label>
                    <input type="text" class="form-control" name="name" value="' . htmlspecialchars($row['farmer_name']) . '" required>
                  </div>';
        $html .= '<div class="col-md-6 mb-2">
                    <label>Phone Number</label>
                    <input type="text" class="form-control" name="phone" value="' . htmlspecialchars($row['phone']) . '" required>
                  </div>';
        $html .= '<div class="col-md-6 mb-2">
                    <label>Father\'s Name</label>
                    <input type="text" class="form-control" name="fatherName" value="' . htmlspecialchars($row['farmer_fathername']) . '" required>
                  </div>';
        
        // Fetch Districts
        $districts = $db->query("SELECT * FROM district")->getResultArray();
        
        $html .= '<div class="col-md-6 mb-2">
                    <label>District</label>
                    <select class="form-control" name="dist" onchange="getTaluks(this.value)" required>
                    <option value=""></option>';
        foreach ($districts as $dist) {
            $selected = ($dist['district'] == $row['district_name']) ? "selected" : "";
            $html .= '<option value="' . htmlspecialchars($dist['code']) . '" ' . $selected . '>' . htmlspecialchars($dist['district']) . '</option>';
        }
        $html .= '</select></div>';
        
        $html .= '<div class="col-md-6 mb-2">
                    <label>Taluk</label>
                    <select class="form-control" name="taluk" id="talukLists" onchange="getVillages(this.value)" required>
                        <option>' . htmlspecialchars($row['taluk_name']) . '</option>
                    </select>
                  </div>';
        
        $html .= '<div class="col-md-6 mb-2">
                    <label>Village</label>
                    <input type="text" name="village" class="form-control" list="villageLists" value="' . htmlspecialchars($row['village_name']) . '">
                    <datalist id="villageLists">
                        <option value="">Select Taluk</option>
                    </datalist>
                  </div>';
        
        $html .= '<div class="col-md-6 mb-2">
                    <label>Aadhaar Number</label>
                    <input type="text" class="form-control" name="adhaar" value="' . htmlspecialchars($row['id_proof_num']) . '">
                  </div>';
        $html .= '<div class="col-md-6 mb-2">
                    <label>Pincode</label>
                    <input type="text" class="form-control" name="pin" value="' . htmlspecialchars($row['pin_code']) . '">
                  </div>';
        
        // Fetch Survey Centers
        $surveyCenters = $db->query("SELECT * FROM SurveyCenterData ORDER BY id DESC")->getResultArray();
        
        $html .= '<div class="col-md-6 mb-2">
                    <label>TSC (Technical Support Centre)</label>
                    <input class="form-control" name="tsc" required>
                </div>';
        
        // Categories
        $categories = ["Farmers", "Black Box Agents", "Chawki Agents", "Franchies"];
        
        $html .= '<div class="col-md-6 mb-2">
                    <label>Category</label>
                    <select name="cat" class="form-control">
                    <option value=""></option>';
        foreach ($categories as $cat) {
            $selected = ($row['category'] == $cat) ? "selected" : "";
            $html .= '<option ' . $selected . '>' . htmlspecialchars($cat) . '</option>';
        }
        $html .= '</select></div>';
        
        $html .= '</div>'; // Close row
        
        return $html;
    }
    
    

    
    public function getFarmerDetails() {
        $phone = $this->request->getGet('phone');
    
        if (!$phone) {
            return $this->response->setJSON(['status' => false, 'message' => 'Phone number is required']);
        }
    
        $db = \Config\Database::connect();
        $query = $db->query("SELECT * FROM tbl_info WHERE phone = ?", [$phone]);
        $row = $query->getRowArray();
    
        if (!$row) {
            return $this->response->setJSON(['status' => false, 'message' => 'No records found']);
        }
    
        $html = '
            <div class="col-md-4 mb-2">
                <label>Farmer ID</label>
                <input type="text" class="form-control" name="fid" value="' . htmlspecialchars($row['farmer_id']) . '" readonly>
            </div>	 
            <div class="col-md-4 mb-2">
                <label>Farmer Name</label>
                <input type="text" class="form-control" name="fin" value="' . htmlspecialchars($row['farmer_name']) . '" readonly>
            </div>	
            <div class="col-md-4 mb-2">
                <label>Father\'s Name</label>
                <input type="text" class="form-control" name="fatherName" value="' . htmlspecialchars($row['farmer_fathername']) . '" readonly>
            </div>	 
            <div class="col-md-4 mb-2">
                <label>Village</label>
                <input type="text" class="form-control" name="village" value="' . htmlspecialchars($row['village_name']) . '" readonly>
            </div>	 
            <div class="col-md-4 mb-2">
                <label>Taluk</label>
                <input type="text" class="form-control" name="taluk" value="' . htmlspecialchars($row['taluk_name']) . '" readonly>
            </div>	 
            <div class="col-md-4 mb-2">
                <label>District</label>
                <input type="text" class="form-control" name="dist" value="' . htmlspecialchars($row['district_name']) . '" readonly>
            </div>	 
            <div class="col-md-4 mb-2">
                <label>Aadhaar Number</label>
                <input type="text" class="form-control" name="adhaar" value="' . htmlspecialchars($row['id_proof_num']) . '" readonly>
            </div>	 
            <div class="col-md-4 mb-2">
                <label>Pincode</label>
                <input type="text" class="form-control" name="pin" value="' . htmlspecialchars($row['pin_code']) . '" readonly>
            </div>	 
            <div class="col-md-4 mb-2">
                <label>Category</label>
                <input type="text" class="form-control" name="cat" value="' . htmlspecialchars($row['category']) . '" readonly>
            </div>';
    
        return $this->response->setJSON(['status' => true, 'html' => $html]);
    }
    

    public function getSolDetails()
    {
        $id = $this->request->getGet('id');
        $type = $this->request->getGet('type');

        $db = \Config\Database::connect();
        $sql = "SELECT * FROM sold_details WHERE LOWER(type) = LOWER(?) AND oid = ?";
        $result = $db->query($sql, [$type, $id]);

        $html = '';

        if (count($result->getResultArray()) == 0) {
            // If no record is found, generate empty form
            $html .= $this->generateHtmlForm();
        } else {
            $data = $result->getRowArray(); // Get the first result
            $html .= $this->generateHtmlForm($data); // Pass data for dynamic population
        }

        echo $html;
    }

    private function generateHtmlForm($data = [])
    {
        // Populate form fields dynamically based on the data provided
        $formFields = [
            'purchase_date' => [
                'label' => 'Purchase Date',
                'type' => 'date',
                'step' => null,
                'id' => 'purchase_date',
            ],
            'quantity' => [
                'label' => 'Purchase Quantity of DFLS',
                'type' => 'number',
                'step' => '0.01',
                'id' => 'quantity',
            ],
            'lot_no' => [
                'label' => 'Lot No',
                'type' => 'text',
                'step' => null,
                'id' => 'lot_no',
            ],
            'sold_date' => [
                'label' => 'Sold Date',
                'type' => 'date',
                'step' => null,
                'id' => 'sold_date',
            ],
            'good_coc' => [
                'label' => 'Good Cocoons (Kg)',
                'type' => 'number',
                'step' => '0.0001',
                'id' => 'gc',
            ],
            'fizmy_coc' => [
                'label' => 'Flimsy Cocoons (Kg)',
                'type' => 'number',
                'step' => '0.0001',
                'id' => 'fl',
            ],
            'total_yield_kg' => [
                'label' => 'Total (kg)',
                'type' => 'number',
                'step' => '0.0001',
                'readonly' => true,
                'id' => 'totalkg',
            ],
            'rate_per_kg' => [
                'label' => 'Cocoon Rate / Kg (₹)',
                'type' => 'number',
                'step' => '0.001',
                'id' => 'rate_per_kg',
            ],
            'total_amt' => [
                'label' => 'Total Amount (₹)',
                'type' => 'number',
                'step' => '0.0001',
                'id' => 'total_amt',
                'readonly' => true,
            ],
        ];

        $html = '';
        foreach ($formFields as $name => $field) {
            $value = $data[$name] ?? ''; // Use value from $data or default to empty
            $readonly = isset($field['readonly']) ? 'readonly' : '';
            $step = $field['step'] ? "step=\"{$field['step']}\"" : '';
            $id = $field['id'] ? $field['id'] : '';
            $onkeyup = ($name === 'good_coc' || $name === 'fizmy_coc') ? 'onkeyup="addTotalKg()"' : (($name === 'rate_per_kg') ? 'onkeyup="TotalAmount(this.value)"' : '');

            $html .= "<div class=\"col-md-12 mb-2\">
                        <label>{$field['label']}</label>
                        <input type=\"{$field['type']}\" $step $id $readonly $onkeyup name=\"$name\" value=\"$value\" class=\"form-control\" required>
                      </div>";
        }

        return $html;
    }
    
    public function getIndentDetails() {
        $id = $this->request->getGet('id');
        $type = $this->request->getGet('type');
        $d = date("Y-m-d");
        
    
        if (!$type) {
            return $this->response->setJSON(['status' => false, 'message' => 'Missing parameters']);
        }
    
        $db = \Config\Database::connect();
        $table = ($type === 'cb') ? 'cb_data' : 'bv_data';
    
        $query = $db->query("SELECT lot_number, availabledata FROM $table WHERE indent_moult = ? AND availabledata > ?", [$id, $d]);
        $results = $query->getResultArray();
    
        if (empty($results)) {
            return $this->response->setJSON(['status' => false, 'html' => '<option value="0">No data available</option>']);
        }
    
        $html = '';
        foreach ($results as $row) {
            $dateFormatted = date("d/m/Y", strtotime($row['availabledata']));
            $html .= '<option value="' . htmlspecialchars($row['lot_number'] . ',' . $row['availabledata']) . '">' . $dateFormatted . '</option>';
        }
        
        $html .= '<option value="" selected>choose</option>';
    
        return $this->response->setJSON(['status' => true, 'html' => $html]);
    }



    public function getFarmerOrders()
    {
        // Get the request data
        $_phone = $this->request->getGet('phone');
        $_db = $this->request->getGet('db');

        // Validate the input
        if (empty($_phone) || empty($_db)) {
            echo 0;
            return;
        }

        // Connect to the database
        $db = \Config\Database::connect();

        // Fetch the orders for the farmer
        $sql = "SELECT * FROM " . $_db . "_orders WHERE farmer_phone = ?";
        $query = $db->query($sql, [$_phone]);
        $orders = $query->getResultArray();

        if (count($orders) == 0) {
            echo 0;
            return;
        }

        // Fetch farmer details
        $farmerQuery = $db->query("SELECT * FROM tbl_info WHERE phone = ?", [$_phone]);
        $farmer = $farmerQuery->getRowArray();

        if (!$farmer) {
            echo 0;
            return;
        }

        // Moult list
        $list = explode(",", "Eggs,1st Moult,2nd Moult,3rd Moult");

        // Build the HTML for the table
        $html = '
        <div class="card p-3">
            <div class="table-responsive">
                <table id="example' . htmlspecialchars($_db) . '" class="table table-striped table-bordered text-nowrap w-100" style="min-width: 845px" role="grid" aria-describedby="example_info">
                    <thead>
                        <tr>
                            <th><strong>S/NO</strong></th>
                            <th><strong>Added By</strong></th>
                            <th><strong>Village Name</strong></th>
                            <th><strong>Order Id</strong></th>
                            <th><strong>Quantity</strong></th>
                            <th><strong>Moult</strong></th>
                            <th><strong>Dist Date</strong></th>
                            <th><strong>Order Date</strong></th>
                            <th><strong>Status</strong></th>
                        </tr>
                    </thead>
                    <tbody>';

        $i = 1;
        foreach ($orders as $order) {
            // Fetch the username of the added by user
            $userQuery = $db->query("SELECT username FROM adminlogin WHERE id = ?", [$order['user_id']]);
            $user = $userQuery->getRowArray();

            $html .= '
                <tr>
                    <td>' . $i++ . '</td>
                    <td>' . htmlspecialchars($user['username'] ?? 'Unknown') . '</td>
                    <td>' . htmlspecialchars($farmer['village_name']) . '</td>
                    <td style="background: ' . $this->getOrderStatusColor($order['order_confirm']) . ';">' . htmlspecialchars($order['order_id']) . '</td>
                    <td>' . htmlspecialchars($order['order_quantity']) . '</td>
                    <td>' . htmlspecialchars($list[$order['indent_moult']] ?? 'Unknown') . '</td>
                    <td>' . date("d/m/Y", strtotime($order['order_date'])) . '</td>
                    <td>' . date("d/m/Y", strtotime($order['order_currect_date'])) . '</td>
                    <td>' . ucfirst($order['order_confirm']) . '</td>
                </tr>';
        }

        $html .= '</tbody></table></div></div>';

        echo $html;
    }


    // Helper function to get the color for the order status
    private function getOrderStatusColor($status)
    {
        switch ($status) {
            case 'Not Confirmed':
                return 'yellow !important;';
            case 'Confirmed':
                return 'green !important; color: white;';
            default:
                return 'red !important;';
        }
    }

    public function UpdateOrderApi()
    {
        $db = \Config\Database::connect();
        if (!isset($_GET['db']) || !isset($_GET['action']) || !isset($_GET['id']) || !isset($_GET['fid'])) {
            session()->setFlashdata('msg', 'Invalid request');
            exit;
        }
        $c = "";
        $cancelR = "";
        if ($this->request->getGet('action') == "confirm") {
            $c = "Confirmed";
            $cancelR = $_GET['cr'];
            $sql = "update {$_GET['db']} set order_confirm = ?, cancel = ?, accepted_by = ?  where id = ?";
        } else {
            $c = "Canceled";
            $cancelR = $_GET['cr'];
            $sql = "update {$_GET['db']} set order_confirm = ?, cancel = ?, canceled_by = ?  where id = ?";
        }
        
        $session = session();

        $query = $db->query($sql, [$c, $cancelR, $session->get('id'), $_GET['id']]);
        if ($query) {
            if ($c == "Confirmed") {
                $indent = ($this->request->getGet("db") == 'cb_orders') ? "CB" : "BV";
                $user = $this->request->getPost("farmer_id");
                $title = "$indent Order Confirmed";
                $body = "Your order is been confirmed";
                $page = "Order";
                $sql = "INSERT INTO Notification_farmer(farmer_id,title,body,page) VALUES ('$user','$title','$body','$page');";
                $db->query($sql);
            }
            echo 1;
        } else {
            echo 0;
        }
    }





    public function login()
    {
        $data = [];
        $data['TITLE'] = "Login";
        return view('login', $data);
    }

    public function login_post()
    {

        $session =  session();
        $err = false;
        if (isset($_POST['sidgnin'])) {

            $db = \Config\Database::connect();
            $phone = $this->request->getPost('phone');
            $password = $this->request->getPost('password');

            $sql = '
                SELECT * FROM adminlogin WHERE phone = ? AND password = ?
            ';
            $query = $db->query($sql, [$phone, $password]);
            $result = $query->getResultArray();
            if (isset($result[0]['id']) && $result[0]['id'] > 0) {
                $ses_data = [
                    'id' => $result[0]['id'],
                    'is_admin' => true
                ];
                $session->set($ses_data);
                if ($result[0]['role'] == "Complaints") {
                    return redirect()->to('admin/complaints');
                } else {
                    return redirect()->to('admin/dashboard');
                }
            } else {
                $err = true;
                $session->setFlashdata('err', true);
                return redirect()->to('admin/login');
            }
        }

        $session->setFlashdata('err', true);
        return redirect()->to('admin/login');
    }

    public function get_head_sidebar()
    {
        $session = session();
        $db = \Config\Database::connect();
        $sql = '
            SELECT * FROM adminlogin WHERE id = ?
        ';
        $query = $db->query($sql, [$session->get('id')]);
        $result = $query->getResultArray();
        $USER = $result[0];

        $sql = 'select * from Notification_admin where role= ?';
        $query = $db->query($sql, [$USER['role']]);
        $result = $query->getResultArray();
        $data['notifications'] = $result;
        $data['USER'] = $USER;
        $data['notification_count'] = count($result);

        return $data;
    }


    public function dashboard()
    {
        $session = session();

        $user_id = $session->get('id');
        $sql = '
            SELECT * FROM adminlogin WHERE id = ?
        ';
        $db = \Config\Database::connect();
        $query = $db->query($sql, [$user_id]);
        $result = $query->getResultArray();
        $USER = $result[0];

        $data = $this->get_head_sidebar();

        $data['TITLE'] = "Dashboard";

        $data['msg'] = "";
        $data['err'] = false;
        if ($USER['role'] == "Complaints") {
            return redirect()->to('admin/complaints');
        }

        $sql = '
            SELECT * FROM cb_data where hatchingdate > CURDATE() ORDER BY id DESC
        ';

        $query = $db->query($sql);
        $result = $query->getResultArray();
        $data['cb_data'] = $result;

        $sql = '
            SELECT * FROM bv_data where hatchingdate > CURDATE() ORDER BY id DESC
        ';
        $query = $db->query($sql);
        $result = $query->getResultArray();
        $data['bv_data'] = $result;
        return view('dashboard', $data);
    }

    public function dashboard_post()
    {
        $data = $this->get_head_sidebar();
        $user_id = $data['USER']['id'];

        $db = \Config\Database::connect();
        $msg = "";
        $err = false;

        $session = session();
        if (isset($_POST['del'])) {
            $_type = $this->request->getPost('type');
            $_id = $this->request->getPost('id');

            $sql = "DELETE FROM {$_type} WHERE id = {$_id}";
            $query = $db->query($sql);
            if ($query) {
                $msg = "Entry Deleted!";
            } else {
                $msg = "Something Went Wrong!";
                $err = true;
            }
        }

        if (isset($_POST["newCb"])) {
            $selectedIntentMoult = $this->request->getPost("indent");
            $hatchdate = $this->request->getPost("hatchDate");
            $date = $this->request->getPost("distDate");
            $quantity = $this->request->getPost("qty");
            $lot_number = $this->request->getPost("lot");

            $sql = "INSERT INTO `cb_data`(`availabledata`, `quantity`,`totalQuantity`,`lot_number`,`hatchingdate`,`indent_moult`) VALUES ('$date','$quantity','$quantity','$lot_number','$hatchdate','$selectedIntentMoult');";
            $query = $db->query($sql);
            if ($query) {
                $msg = "New CB Entry Added!";
            } else {
                $msg = "Something Went Wrong!";
                $err = true;
            }
        }

        if (isset($_POST["newBv"])) {
            $selectedIntentMoult = $this->request->getPost("indent");
            $hatchdate = $this->request->getPost("hatchDate");
            $date = $this->request->getPost("distDate");
            $quantity = $this->request->getPost("qty");
            $lot_number = $this->request->getPost("lot");

            $sql = "INSERT INTO `bv_data`(`availabledata`, `quantity`,`totalQuantity`,`lot_number`,`hatchingdate`,`indent_moult`) VALUES ('$date','$quantity','$quantity','$lot_number','$hatchdate','$selectedIntentMoult');";
            $result = $db->query($sql);
            if ($result) {
                $msg = "New BV Entry Added!";
            } else {
                $msg = "Something Went Wrong!";
                $err = true;
            }
        }
        $session->setFlashdata('msg', $msg);
        return redirect()->to('admin/dashboard');
    }


    public function new_registration()
    {




        $data = $this->get_head_sidebar();
        $data['TITLE'] = 'New Registration';
        $data['err'] = false;
        $data['msg'] = "";

        $_all = $this->request->getGet('all');

        $db = \Config\Database::connect();
        $sql = '';
        if ($_all) {
            $sql .= "SELECT `farmer_id`, `farmer_name`, `farmer_fathername`,`phone`,`village_name`,`taluk_name`,`district_name`,`pin_code`, `category`,`survey_center`,id FROM tbl_info where 1=1 ORDER BY id ASC";
        } else {
            $sql .= "
                SELECT `farmer_id`, `farmer_name`, `farmer_fathername`,`phone`,`village_name`,`taluk_name`,`district_name`,`pin_code`, `category`,`survey_center`,id 
                FROM tbl_info where 1=1 ORDER BY id ASC limit 200";
        }

        // $sql = "SELECT * FROM tbl_info ORDER BY id ASC limit 200";
        $query = $db->query($sql);

        $result = $query->getResultArray();
        $data['farmer_data'] = $result;

        $sql = "SELECT * FROM tbl_info ORDER BY id ASC";
        $query = $db->query($sql);
        $result = $query->getResultArray();
        $data["farmer_data_all"] = $result;

        // $res = mysqli_query($conn, "select * from district");
        $sql = "SELECT * FROM district";
        $query = $db->query($sql);
        $result = $query->getResultArray();
        $data['district_data'] = $result;

        // $res = mysqli_query($conn, "select * from SurveyCenterData ORDER BY id DESC");
        $sql = "SELECT * FROM SurveyCenterData ORDER BY id DESC";
        $query = $db->query($sql);
        $result = $query->getResultArray();
        $data["surveycenterdata"] = $result;

        return view('new_registration', $data);
    }


    public function new_registration_post()
    {
        $data = $this->get_head_sidebar();
        $data['TITLE'] = 'New Registration';
        $db = \Config\Database::connect();
        $msg = "";
        $err = false;
        $data["msg"] = $msg;
        $data["err"] = $err;

        if(isset($_POST['editNewUser'])){
            // "id": "165",
            // "name": "Narendra Kumar Reddy",
            // "phone": "08790729468",
            // "fatherName": "qw",
            // "dist": "DIST10099568",
            // "taluk": "aasdfaf",
            // "village": "ಕೊರಟಗೆರೆ",
            // "adhaar": "46524365435434346",
            // "pin": "516390",
            // "tsc": "545",
            // "cat": "Farmers",
            // "editNewUser": ""


            $id = $this->request->getPost("id");
            $name = $this->request->getPost("name");
            $phone = $this->request->getPost("phone");
            $fatherName = $this->request->getPost("fatherName");
            $dist = $this->request->getPost("dist");
            $taluk = $this->request->getPost("taluk");
            $village = $this->request->getPost("village");
            $adhaar = $this->request->getPost("adhaar");
            $pin = $this->request->getPost("pin");
            $tsc = $this->request->getPost("tsc");
            $cat = $this->request->getPost("cat");

            $district = $db->query("SELECT district FROM district WHERE code = ?", [$dist])->getRowArray()['district'];
            
            
            $sql = "UPDATE tbl_info 
                    SET farmer_name = ?, 
                        phone = ?, 
                        farmer_fathername = ?, 
                        village_name = ?, 
                        taluk_name = ?, 
                        district_name = ?, 
                        pin_code = ?, 
                        category = ?, 
                        survey_center = ?, 
                        id_proof_num = ? 
                    WHERE id = ?";
            $query = $db->query($sql, [$name, $phone, $fatherName, $village, $taluk, $district, $pin, $cat, $tsc, $adhaar, $id]);


            if ($query) {
                $msg = "Farmer Updated!";
                return redirect()->to('admin/new-registration');
            } else {
                $msg = "Something Went Wrong!";
                $err = true;
                return redirect()->to('admin/new-registration');
            }


            return $this->response->setJSON(['status' => false, 'post' => $_POST]);
        }

        // if(isset($_POST['editNewUser'])):
        //     $names = $_POST["name"];
        //     $phones = $_POST["phone"];
        //     $fathernames = $_POST["fatherName"];
            
        //     if(is_numeric($_POST["village"])):
        //         $villages = mysqli_fetch_assoc(mysqli_query($conn, "select name from village where id='$_POST[village]'"))['name'];
        //     else:
        //         $villages = $_POST["village"];
        //         $sqp = mysqli_query($conn, "select * from village where name='$villages'");
                
        //         if(mysqli_num_rows($sqp) == 0):
        //            mysqli_query($conn, "insert into village (`name`, `village_code`) VALUES ('$villages','$_POST[taluk]')");
        //         endif;
        //     endif;
            
        //     $taluks = mysqli_fetch_assoc(mysqli_query($conn, "select taluk from taluk where id='$_POST[taluk]'"))['taluk'];
        //     $districts = mysqli_fetch_assoc(mysqli_query($conn, "select district from district where code='$_POST[dist]'"))['district'];
            
        //     $pincodes= $_POST["pin"];
        //     $categorys = $_POST["cat"];
        //     $surveycenter = $_POST["tsc"];
        //     $adharnumber = $_POST["adhaar"];
    
        //     $sql = "UPDATE tbl_info SET farmer_name = '$names', phone = '$phones', farmer_fathername = '$fathernames', village_name = '$villages', taluk_name = '$taluks', district_name = '$districts', pin_code = '$pincodes', category = '$categorys', survey_center = '$surveycenter', id_proof_num = '$adharnumber' WHERE id = '$_POST[id]'";
    
        //     if(mysqli_query($conn, $sql)):
                
        //         $ID = mysqli_insert_id($conn);
                
        //         $farmer_id = "FA099999$ID"; // "FA0" + 99999 + $id
                
        //         mysqli_query($conn, "update tbl_info set farmer_id='$farmer_id' where id='$ID'");
        //         $msg = "Farmer Updated!";
        //     else:
        //         $msg = "Something Went Wrong!";
        //         $err = true;
        //     endif;
        // endif;


        if (isset($_POST["addNewUser"])) {
            $USER = $data['USER'];
            $user_id = $USER['id'];
            $names = $this->request->getPost("name");
            $phones = $this->request->getPost("phone");
            $fathernames = $this->request->getPost("fatherName");

            $districts = $this->request->getPost("dist");
            $taluks = $this->request->getPost("taluk");
            $villages = $this->request->getPost("village");
            $pincodes = $this->request->getPost("pin");
            $categorys = $this->request->getPost("cat");
            $surveycenter = $this->request->getPost("tsc");
            $adharnumber = $this->request->getPost("adhaar");

            $sql = "INSERT INTO tbl_info (user_id,farmer_name,phone,farmer_fathername,village_name,taluk_name,district_name,pin_code,category,survey_center,id_proof_num) VALUES ('$user_id','$names', '$phones', '$fathernames','$villages','$taluks','$districts','$pincodes','$categorys','$surveycenter','$adharnumber');";


            $query = $db->query($sql);
            if ($query) {
                $ID = $db->insertID();
                $farmer_id = "FA099999$ID"; // "FA0" + 99999 + $id
                $sql = "UPDATE tbl_info set farmer_id='$farmer_id' where id='$ID'";
                $query = $db->query($sql);
                $msg = "New Farmer Registered!";
                
                return redirect()->to('admin/new-registration');
            } else {
                $msg = "Something Went Wrong!";
                $err = true;
                
                return redirect()->to('admin/new-registration');
            }
        }

        if (isset($_POST["delete_enty"])) {
            $id = $this->request->getPost("id");
            $sql = "DELETE FROM tbl_info WHERE id = ?";
            $query = $db->query($sql, [$id]);
            if ($query) {
                $msg = "Farmer deleted!";
                
                return redirect()->to('admin/new-registration');
            } else {
                $msg = "Something Went Wrong!";
                $err = true;
                
                return redirect()->to('admin/new-registration');
            }
        }

        if (isset($_POST["filetR"])) {
            $sql = "SELECT `farmer_id`, `farmer_name`, `farmer_fathername`,`phone`,`village_name`,`taluk_name`,`district_name`,`pin_code`, `category`,`survey_center`,id FROM tbl_info where 1=1";
            $fid = $this->request->getPost("fid");
            $cat = $this->request->getPost("cat");

            if (!empty($fid)) {
                $sql .= " and farmer_id='$fid' or phone='$fid'";
            }

            if (!empty($cat)) {
                $sql .= " and category='$cat'";
            }

            $sql .= " ORDER BY id ASC";
            $query = $db->query($sql);
            $result = $query->getResultArray();
            $data["farmer_data"] = $result;


            $sql = "SELECT * FROM tbl_info ORDER BY id ASC";
            $query = $db->query($sql);
            $result = $query->getResultArray();
            $data["farmer_data_all"] = $result;

            // $res = mysqli_query($conn, "select * from district");
            $sql = "SELECT * FROM district";
            $query = $db->query($sql);
            $result = $query->getResultArray();
            $data['district_data'] = $result;

            // $res = mysqli_query($conn, "select * from SurveyCenterData ORDER BY id DESC");
            $sql = "SELECT * FROM SurveyCenterData ORDER BY id DESC";
            $query = $db->query($sql);
            $result = $query->getResultArray();
            $data["surveycenterdata"] = $result;

            return view('new_registration', $data);
        } else {
            $sql = "SELECT `farmer_id`, `farmer_name`, `farmer_fathername`,`phone`,`village_name`,`taluk_name`,`district_name`,`pin_code`, `category`,`survey_center`,id FROM tbl_info where 1=1 ORDER BY id ASC limit 200";
            $query = $db->query($sql);
            $result = $query->getResultArray();
            $data["farmer_data"] = $result;

            $sql = "SELECT * FROM tbl_info ORDER BY id ASC";
            $query = $db->query($sql);
            $result = $query->getResultArray();
            $data["farmer_data_all"] = $result;

            // $res = mysqli_query($conn, "select * from district");
            $sql = "SELECT * FROM district";
            $query = $db->query($sql);
            $result = $query->getResultArray();
            $data['district_data'] = $result;

            // $res = mysqli_query($conn, "select * from SurveyCenterData ORDER BY id DESC");
            $sql = "SELECT * FROM SurveyCenterData ORDER BY id DESC";
            $query = $db->query($sql);
            $result = $query->getResultArray();
            $data["surveycenterdata"] = $result;

            return view('new_registration', $data);
        }
    }

    public function manual_orders()
    {
        $data = $this->get_head_sidebar();

        $data['TITLE'] = 'Manual Orders';
        $data['err'] = false;
        $data['msg'] = "";

        $db =  \Config\Database::connect();
        $conn = $db->connect();

        if(isset($_POST['NewOrder'])):
            $farmer_id = $_POST["fid"];
            $order_id = "KCRCCB099".rand(111,999)."0$farmer_id";
            $order_date = explode(",",$_POST['avaDate'])[1];
            $order_quantity = $_POST["qty"];
            $lot_number = explode(",",$_POST['avaDate'])[0];
            $order_confirm ='Not Confirmed';
            
            $farmer_phone = $_POST["farmer"];
            
            $category = $_POST["cat"];
            $moult = $_POST["indent"];
            $onbehalf = "Admin";
            $chawki_id = "NULL";
            $currentDate = date('Y-m-d');
            
            if($_POST['db']  == "cb_orders"):
                $indenttype = "CB";
            else:
                $indenttype = "BV";
            endif;
            
            $sqlgetlotnumber= " SELECT quantity FROM `$_POST[data]` WHERE availabledata = '$order_date';";
    
            $result11=mysqli_query($conn,$sqlgetlotnumber);
        
            $list="";
            $list2 = "";
        
            while($row=mysqli_fetch_array($result11)){
                $list=$row[0];
            }
            
            $updatedquantity = $list - $order_quantity;
            $sqlupdatequantity = "UPDATE $_POST[data] SET quantity=$updatedquantity where availabledata='$order_date';";
        
            if($list<$order_quantity){
                $msg = "Please enter quantity that is available as listed below";
                $err = true;
            }else{
                $ID = session()->get('id');
                $sql = "INSERT INTO $_POST[db] (user_id,farmer_id,farmer_phone,order_id,order_date,order_quantity,order_confirm,lot_number,order_currect_date,category,indent_moult,indent_type,on_behalf,chawki_id) VALUES ('$ID','$farmer_id','$farmer_phone','$order_id','$order_date','$order_quantity','$order_confirm','$lot_number','$currentDate','$category','$moult','$indenttype','$onbehalf','$chawki_id');";
        
                if ( mysqli_query($conn, $sql) ) {
                    $user = $farmer_id;
                    $title = "$indenttype Order Booked QTY: $order_quantity";
                    $body = "Your order is been Placed (behalf of admin)";
                    $page = "Order";
                
                    $sql = "INSERT INTO Notification_farmer(farmer_id,title,body,page) VALUES ('$user','$title','$body','$page');";
                    mysqli_query($conn, $sql);
                
                    
                    $msg = "Order Placed Successfully";
                    mysqli_query($conn,$sqlupdatequantity);
                } else {
                    $msg = "Something went wrong!".$conn->error;
                    $err = true; 
                }
            }
        endif;
        

        // farmer_data_all
        $sql = "SELECT * FROM tbl_info ORDER BY id ASC";
        $query = $db->query($sql);

        $result = $query->getResultArray();
        $data['farmer_data_all'] = $result;

        return view('manual_orders', $data);
    }






    public function manage_user()
    {
        $data = $this->get_head_sidebar();
        $data['TITLE'] = 'Manage User';
        $data['err'] = false;
        $data['msg'] = "";
        $db = \Config\Database::connect();

        $sql = "SELECT * FROM adminlogin ORDER BY id DESC";
        $query = $db->query($sql);
        $result = $query->getResultArray();
        $data["users_data"] = $result;

        return view('manage_user', $data);
    }

    public function manage_user_post()
    {

        $db = \Config\Database::connect();
        if (isset($_POST['addNewUser'])) {
            $phone = $this->request->getPost("phone");
            $password = $this->request->getPost("password");
            $userid = "KCRC0982" . rand(111, 999);
            $username = $this->request->getPost("name");
            $role = $this->request->getPost("role");
            $sql = "INSERT INTO adminlogin (phone,password,userID,username,role) VALUES ('$phone','$password', '$userid', '$username','$role');";
            $query = $db->query($sql);
            if ($query) {
                session()->setFlashdata('msg', 'New User Added!');
                return redirect()->to('admin/manage-user');
            } else {
                session()->setFlashdata('msg', 'Something Went Wrong!');
                return redirect()->to('admin/manage-user');
            }
        }

        if (isset($_POST['del'])) {
            $id = $this->request->getPost("id");
            $sql = "DELETE FROM adminlogin WHERE id = ?";
            $query = $db->query($sql, [$id]);
            if ($query) {
                session()->setFlashdata('msg', 'User Deleted!');
                return redirect()->to('admin/manage-user');
            } else {
                session()->setFlashdata('msg', 'Something Went Wrong!');
                return redirect()->to('admin/manage-user');
            }
        }
    }


    public function price_fixation()
    {
        $db = \Config\Database::connect();
        $data = $this->get_head_sidebar();
        $data['TITLE'] = 'Price Fixation';
        $data['err'] = false;
        $data['msg'] = "";

        $sql = "SELECT * FROM indent_price ORDER BY id DESC";
        $query = $db->query($sql);
        $result = $query->getResultArray();
        $data['price_fixation'] = $result;

        return view('price_fixation', $data);
    }

    public function price_fixation_post()
    {
        $db = \Config\Database::connect();
        if (isset($_POST['newPrice'])) {
            $date = $this->request->getPost('date');
            $cat = $this->request->getPost('cat');
            $indent = $this->request->getPost('indent');
            $price = $this->request->getPost('price');

            $moult = explode(",", $indent)[0];
            $indent_type = explode(",", $indent)[1];

            $sql = "INSERT INTO indent_price (indent_date,farmer_category,indent_type,price,indent,moult) VALUES ('$date','$cat', '$indent_type', '$price','$indent','$moult');";
            $query = $db->query($sql);
            if ($query) {
                session()->setFlashdata('msg', 'New Price Added!');
                return redirect()->to('admin/price-fixation');
            } else {
                session()->setFlashdata('msg', 'Something Went Wrong!');
                return redirect()->to('admin/price-fixation');
            }
        }

        if (isset($_POST['del'])) {
            $id = $this->request->getPost('id');
            $type = $this->request->getPost('type');
            $sql = "DELETE FROM $type WHERE id = ?";
            $query = $db->query($sql, [$id]);
            if ($query) {
                session()->setFlashdata('msg', 'Entry Deleted!');
                return redirect()->to('admin/price-fixation');
            } else {
                session()->setFlashdata('msg', 'Something Went Wrong!');
                return redirect()->to('admin/price-fixation');
            }
        }
    }


    public function complaints()
    {
        $db = \Config\Database::connect();
        $data = $this->get_head_sidebar();
        $data['TITLE'] = 'Complaints';
        $data['err'] = false;
        $data['msg'] = "";

        $sql = "SELECT * FROM complaints ORDER BY id DESC";
        $query = $db->query($sql);
        $result = $query->getResultArray();
        $data['complaints'] = $result;

        $sql = "select * from extensionOfficer";
        $query = $db->query($sql);
        $result = $query->getResultArray();
        $data['extensionOfficer'] = $result;

        $sql = 'select * from message';
        $query = $db->query($sql);
        $result = $query->getResultArray();
        $data['messages_data'] = $result;

        return view('complaints', $data);
    }

    public function complaints_post()
    {

        $db = \Config\Database::connect();
        if (isset($_POST['newPrice'])) {
            $id = $this->request->getPost('id');
            $reply = $this->request->getPost('msg');
            $contactNo = explode(",", $this->request->getPost('cont'))[1];
            $name = explode(",", $this->request->getPost('cont'))[0];

            $sql = "UPDATE complaints SET admin_replay ='$reply', contactNo ='$contactNo', contactName ='$name' WHERE id='$id';";
            $query = $db->query($sql);
            if ($query) {
                session()->setFlashdata('msg', 'New Reply Added!');
                return redirect()->to('admin/complaints');
            } else {
                session()->setFlashdata('msg', 'Something Went Wrong!');
                return redirect()->to('admin/complaints');
            }
        }
        return redirect()->to('admin/complaints');
    }


    public function complaints_report()
    {
        $db = \Config\Database::connect();
        $data = $this->get_head_sidebar();
        $data['TITLE'] = 'Complaints';
        $data['err'] = false;
        $data['msg'] = "";

        $sql = "SELECT * FROM complaints ORDER BY id DESC";
        $query = $db->query($sql);
        $result = $query->getResultArray();
        $data['complaints'] = $result;

        $sql = "select * from extensionOfficer";
        $query = $db->query($sql);
        $result = $query->getResultArray();
        $data['extensionOfficer'] = $result;

        $sql = 'select * from message';
        $query = $db->query($sql);
        $result = $query->getResultArray();
        $data['messages_data'] = $result;

        return view('complaints_report', $data);
    }

    public function complaints_report_post()
    {

        $db = \Config\Database::connect();
        if (isset($_POST['newPrice'])) {
            $id = $this->request->getPost('id');
            $reply = $this->request->getPost('msg');
            $contactNo = explode(",", $this->request->getPost('cont'))[1];
            $name = explode(",", $this->request->getPost('cont'))[0];

            $sql = "UPDATE complaints SET admin_replay ='$reply', contactNo ='$contactNo', contactName ='$name' WHERE id='$id';";
            $query = $db->query($sql);
            if ($query) {
                session()->setFlashdata('msg', 'New Reply Added!');
                return redirect()->to('admin/complaints');
            } else {
                session()->setFlashdata('msg', 'Something Went Wrong!');
                return redirect()->to('admin/complaints');
            }
        }
        return redirect()->to('admin/complaints-report');
    }


    public function cacoon_yeilds_details()
    {
        $db = \Config\Database::connect();
        $data = $this->get_head_sidebar();
        $data['TITLE'] = 'Cacoon Yeilds Details';
        $data['err'] = false;
        $data['msg'] = "";

        $sql = "
            SELECT 
                id, indent_type, order_quantity, indent_moult, order_id, order_date, farmer_phone, farmer_id, lot_number 
            FROM 
                bv_orders 
            WHERE 
                order_currect_date 
            UNION 
            SELECT 
                id, indent_type, order_quantity, indent_moult, order_id, order_date, farmer_phone, farmer_id, lot_number 
            FROM 
                cb_orders 
            WHERE 
                order_currect_date limit 200;
        ";


        $query = $db->query($sql);
        $result = $query->getResultArray();


        $data['cacoon_yeilds'] = $result;
        return view('cacoon_yeilds_details', $data);
    }


    public function cacoon_yeilds_details_post()
    {
        $db = \Config\Database::connect();
        $data = $this->get_head_sidebar();
        $data['TITLE'] = 'Cacoon Yeilds Details';
        $data['err'] = false;
        $data['msg'] = "";

        if (isset($_POST['newConfirm'])) {
            $type = $this->request->getPost('type');
            $oid = $this->request->getPost('oid');

            // Fetch farmer details based on the order type
            if ($type == "bv") {
                $sql = "SELECT farmer_id, farmer_phone FROM bv_orders WHERE id = ?";
            } else {
                $sql = "SELECT farmer_id, farmer_phone FROM cb_orders WHERE id = ?";
            }
            $query = $db->query($sql, [$oid]);
            $order = $query->getRowArray();

            if ($order) {
                $dataToInsert = [
                    'farmer_id' => $order['farmer_id'],
                    'farmer_phone' => $order['farmer_phone'],
                    'type' => $type,
                    'oid' => $oid,
                    // Add additional fields from POST data dynamically
                ];

                foreach ($this->request->getPost() as $key => $value) {
                    if (!in_array($key, ['newConfirm', 'type', 'oid'])) {
                        $dataToInsert[$key] = $value;
                    }
                }

                // Check if record already exists in sold_details
                $checkSql = "SELECT * FROM sold_details WHERE oid = ? AND type = ?";
                $checkQuery = $db->query($checkSql, [$oid, $type]);

                if ($checkQuery->getNumRows() > 0) {
                    // Update the existing record
                    $updateResult = $db->table('sold_details')
                        ->where('oid', $oid)
                        ->where('type', $type)
                        ->update($dataToInsert);

                    if ($updateResult) {
                        session()->setFlashdata('msg', 'Sold Details Updated!');
                    } else {
                        session()->setFlashdata('msg', 'Something Went Wrong!');
                    }
                } else {
                    // Insert a new record
                    $insertResult = $db->table('sold_details')->insert($dataToInsert);

                    if ($insertResult) {
                        session()->setFlashdata('msg', 'Sold Details Added!');
                    } else {
                        session()->setFlashdata('msg', 'Something Went Wrong!');
                    }
                }
            } else {
                session()->setFlashdata('msg', 'Order not found!');
            }
        }

        if (isset($_POST['filetNow'])) {
            $fromDate = $this->request->getPost('fromDate');
            $toDate = $this->request->getPost('toDate');

            $sql = "
                SELECT id, indent_type, order_quantity, indent_moult, order_id, order_date, farmer_phone, farmer_id, lot_number
                FROM bv_orders 
                WHERE order_currect_date BETWEEN ? AND ?
                UNION 
                SELECT id, indent_type, order_quantity, indent_moult, order_id, order_date, farmer_phone, farmer_id, lot_number
                FROM cb_orders 
                WHERE order_currect_date BETWEEN ? AND ?
            ";
            $query = $db->query($sql, [$fromDate, $toDate, $fromDate, $toDate]);
        }

        $results = $query->getResultArray();

        // Fetch sold details for each record
        foreach ($results as &$row) {
            $soldDetailsQuery = "
                SELECT * 
                FROM sold_details 
                WHERE oid = ? AND LOWER(type) = LOWER(?)
            ";
            $soldDetails = $db->query($soldDetailsQuery, [$row['id'], $row['indent_type']])->getRowArray();
            $row['sold_details'] = $soldDetails; // Append sold details to each row
        }

        $data['cacoon_yeilds'] = $results;
        return view('cacoon_yeilds_details', $data);
    }



    // reports//

    public function indent_report() {
        $sql = "select bv.*, tbl_info.farmer_name from cb_orders bv INNER JOIN tbl_info on tbl_info.phone = bv.farmer_phone where 1=1";
        if(isset($_POST['filterCb'])):
            if(isset($_POST['fromDate']) && !empty($_POST['fromDate'])):
                if(isset($_POST['dateType']) && !empty($_POST['dateType'])):
                    if($_POST['dateType'] == 0):
                        $type = "`order_currect_date`";
                    else:
                        $type = "`order_date`";
                    endif;
                else:
                    $type = "`order_currect_date`";
                endif;
                
                $sql .= " and $type>='$_POST[fromDate]'";
            endif;
            
            if(isset($_POST['toDate']) && !empty($_POST['toDate'])):
                if(isset($_POST['dateType']) && !empty($_POST['dateType'])):
                    if($_POST['dateType'] == 0):
                        $type = "`order_currect_date`";
                    else:
                        $type = "`order_date`";
                    endif;
                else:
                    $type = "`order_currect_date`";
                endif;
                
                $sql .= " and $type<='$_POST[toDate]'";
            endif;
            
            
            
            if(isset($_POST['status']) && !empty($_POST['status'])):
                $sql .= " and order_confirm='$_POST[status]'";
            endif;
            
            
            if(isset($_POST['type']) && $_POST['type'] != "All"):
                $sql .= " and category='$_POST[type]' or on_behalf='$_POST[type]'";
            endif;
        endif;
    
        $sql .= " ORDER BY id DESC";

        $db = \Config\Database::connect();
        $data = $this->get_head_sidebar();

        $data['TITLE'] = 'Indent Report';
        $data['err'] = false;
        $data['default'] = false;
        $data['msg'] = "";

        $data['cb_orders'] = $db->query($sql)->getResultArray();

        $sql = "select bv.*, tbl_info.farmer_name from bv_orders bv INNER JOIN tbl_info on tbl_info.phone = bv.farmer_phone where 1=1";
        if(isset($_POST['filterBv'])):
            if(isset($_POST['fromDate']) && !empty($_POST['fromDate'])):
                if(isset($_POST['dateType']) && !empty($_POST['dateType'])):
                    if($_POST['dateType'] == 0):
                        $type = "`order_currect_date`";
                    else:
                        $type = "`order_date`";
                    endif;
                else:
                    $type = "`order_currect_date`";
                endif;
                
                $sql .= " and $type>='$_POST[fromDate]'";
            endif;
            
            if(isset($_POST['toDate']) && !empty($_POST['toDate'])):
                if(isset($_POST['dateType']) && !empty($_POST['dateType'])):
                    if($_POST['dateType'] == 0):
                        $type = "`order_currect_date`";
                    else:
                        $type = "`order_date`";
                    endif;
                else:
                    $type = "`order_currect_date`";
                endif;
                
                $sql .= " and $type<='$_POST[toDate]'";
            endif;
            
            
            
            if(isset($_POST['status']) && !empty($_POST['status'])):
                $sql .= " and order_confirm='$_POST[status]'";
            endif;
            
            
            if(isset($_POST['type']) && $_POST['type'] != "All"):
                $sql .= " and category='$_POST[type]' or on_behalf='$_POST[type]'";
            endif;
        endif;
    
        $sql .= " ORDER BY id DESC";

        $data['bv_orders'] = $db->query($sql)->getResultArray();

        // return $this->response->setJSON($data);

        return view('indent_report', $data);

    }

    public function yield_report()
    {
        $db = \Config\Database::connect();
        $data = $this->get_head_sidebar();
        $data['TITLE'] = 'Yeild Report';
        $data['err'] = false;
        $data['msg'] = "";

        $sql = "
            SELECT 
                id, indent_type, order_quantity, indent_moult, order_id, order_date, farmer_phone, farmer_id, lot_number 
            FROM 
                bv_orders 
            WHERE 
                order_currect_date 
            UNION 
            SELECT 
                id, indent_type, order_quantity, indent_moult, order_id, order_date, farmer_phone, farmer_id, lot_number 
            FROM 
                cb_orders 
            WHERE 
                order_currect_date limit 200;
        ";


        $query = $db->query($sql);
        $result = $query->getResultArray();


        $data['cacoon_yeilds'] = $result;
        return view('yeild_report', $data);
    }

    public function yield_report_post()
    {
        $db = \Config\Database::connect();
        $data = $this->get_head_sidebar();
        $data['TITLE'] = 'Yeild Report';
        $data['err'] = false;
        $data['msg'] = "";


        if (isset($_POST['filetNow'])) {
            $fromDate = $this->request->getPost('fromDate');
            $toDate = $this->request->getPost('toDate');

            $sql = "
                SELECT id, indent_type, order_quantity, indent_moult, order_id, order_date, farmer_phone, farmer_id, lot_number
                FROM bv_orders 
                WHERE order_currect_date BETWEEN ? AND ?
                UNION 
                SELECT id, indent_type, order_quantity, indent_moult, order_id, order_date, farmer_phone, farmer_id, lot_number
                FROM cb_orders 
                WHERE order_currect_date BETWEEN ? AND ?
            ";
            $query = $db->query($sql, [$fromDate, $toDate, $fromDate, $toDate]);
        }

        $results = $query->getResultArray();

        foreach ($results as &$row) {
            $soldDetailsQuery = "
                SELECT * 
                FROM sold_details 
                WHERE oid = ? AND LOWER(type) = LOWER(?)
            ";
            $soldDetails = $db->query($soldDetailsQuery, [$row['id'], $row['indent_type']])->getRowArray();
            $row['sold_details'] = $soldDetails; // Append sold details to each row
        }

        $data['cacoon_yeilds'] = $results;
        return view('cacoon_yeilds_details', $data);
    }






    public function setting()
    {
        $db = \Config\Database::connect();
        $data = $this->get_head_sidebar();
        $data['TITLE'] = 'Setting';
        $data['err'] = false;
        $data['msg'] = "";

        $officer_sql = "SELECT * FROM extensionOfficer ORDER BY id DESC";
        $officer = $db->query($officer_sql, [])->getResultArray();

        $messege_sql = "SELECT * FROM message ORDER BY id DESC";
        $messege = $db->query($messege_sql, [])->getResultArray();

        $data['officers'] = $officer;
        $data['messeges'] = $messege;

        return view('setting', $data);
    }

    public function setting_post()
    {
        // if(isset($_POST['del'])):
        //     if(mysqli_query($conn, "delete from $_POST[type] where id='$_POST[id]'")):
        //         $msg = "Entry Deleted!";
        //     else:
        //         $msg = "Something Went Wrong!";
        //         $err = true;
        //     endif;
        // endif;

        $db = \Config\Database::connect();

        if (isset($_POST['del'])) {
            $type = $this->request->getPost('type');
            $id = $this->request->getPost('id');

            $sql = 'DELETE FROM ' . $type . ' WHERE id = ' . $id . '';
            $query = $db->query($sql);
            if ($query) {
                session()->setFlashdata('msg', 'Entry Deleted!');
                return redirect()->to('admin/setting');
            } else {
                session()->setFlashdata('msg', 'Something Went Wrong!');
                return redirect()->to('admin/setting');
            }
        }

        if (isset($_POST['newOfficer'])) {
            $name = $this->request->getPost('name');
            $phone = $this->request->getPost('phone');
            $sql = "INSERT INTO extensionOfficer (contactNo, contactName) VALUES ('$phone', '$name')";
            $query = $db->query($sql);
            if ($query) {
                session()->setFlashdata('msg', 'New Officer Added!');
                return redirect()->to('admin/setting');
            } else {
                session()->setFlashdata('msg', 'Something Went Wrong!');
                return redirect()->to('admin/setting');
            }
        }

        if (isset($_POST['newMessafe'])) {
            $msg = $this->request->getPost('msg');
            $sql = "INSERT INTO message (msg) VALUES ('$msg')";
            $query = $db->query($sql);
            if ($query) {
                session()->setFlashdata('msg', 'New Message Added!');
                return redirect()->to('admin/setting');
            } else {
                session()->setFlashdata('msg', 'Something Went Wrong!');
                return redirect()->to('admin/setting');
            }
        }
    }



    // received orders
    



    

    public function bv_pending_orders()
    {
        $db = \Config\Database::connect();
        $data = $this->get_head_sidebar();
        $data['TITLE'] = 'CB Pending Orders';
        $data['err'] = false;
        $data['msg'] = "";
        $date = date('Y-m-d');
        $sql = "SELECT ad.username, cb.ampm,cb.id, cb.user_id, cb.canceled_by, cb.accepted_by, cb.farmer_id, cb.farmer_phone, cb.order_id, cb.order_date, cb.order_quantity, cb.order_confirm, cb.lot_number, cb.order_currect_date, cb.category, cb.indent_moult, cb.indent_type, cb.on_behalf, cb.chawki_id,t.farmer_name,t.farmer_fathername,t.village_name, t.district_name, t.taluk_name, t.survey_center FROM bv_orders cb INNER JOIN tbl_info t on t.phone=cb.farmer_phone INNER JOIN adminlogin ad on ad.id=cb.user_id where 1=1 and order_confirm='Not Confirmed' and order_currect_date>= ".$date." Order by id DESC";
        $query = $db->query($sql);
        $data['orders'] = $query->getResultArray();
        $data['farmers_count'] = count($data['orders']);

        return view('bv_pending_orders', $data);
    }

    public function bv_pending_orders_post()
    {
        $db = \Config\Database::connect();
        $data = $this->get_head_sidebar();
        $data['msg'] = '';
        $data['err'] = false;
        $data['TITLE'] = 'BV Pending Orders';

        $sql = "";

        if (isset($_POST['filterCb'])) {

            $sql = "SELECT ad.username, cb.ampm,cb.id, cb.user_id, cb.canceled_by, cb.accepted_by, cb.farmer_id, cb.farmer_phone, cb.order_id, cb.order_date, cb.order_quantity, cb.order_confirm, cb.lot_number, cb.order_currect_date, cb.category, cb.indent_moult, cb.indent_type, cb.on_behalf, cb.chawki_id,t.farmer_name,t.farmer_fathername,t.village_name, t.district_name, t.taluk_name, t.survey_center FROM bv_orders cb INNER JOIN tbl_info t on t.phone=cb.farmer_phone INNER JOIN adminlogin ad on ad.id=cb.user_id where 1=1 and order_confirm='Not Confirmed'";
            if (isset($_POST['fromDate']) && !empty($_POST['fromDate'])) {
                if (isset($_POST['dateType']) && !empty($_POST['dateType'])) {
                    if ($this->request->getPost('dateType') == 0) {
                        $type = "`order_currect_date`";
                    } else {
                        $type = "`order_date`";
                    }
                } else {
                    $type = "`order_currect_date`";
                }
                $sql .= " and $type>='{$this->request->getPost('fromDate')}'";
            }

            if (isset($_POST["toDate"]) && !empty($_POST['toDate'])) {
                if (isset($_POST['dateType']) && !empty($_POST['dateType'])) {
                    if ($this->request->getPost('dateType') == 0) {
                        $type = "`order_currect_date`";
                    } else {
                        $type = "`order_date`";
                    }
                } else {
                    $type = "`order_currect_date`";
                }
                $sql .= " and $type<='{$this->request->getPost('toDate')}'";
            }
            if (isset($_POST["type"]) && $this->request->getPost("type") != 'All') {
                $sql .= " and category='{$this->request->getPost('type')}' or on_behalf='{$this->request->getPost('type')}'";
            }
            if (isset($_POST["ampm"]) && $this->request->getPost("ampm") != "All") {
                $sql .= " and ampm='{$this->request->getPost('ampm')}'";
            }
        }

        $sql .= " Order by id DESC";

        $query = $db->query($sql);

        $data['orders'] = $query->getResultArray();
        $data['farmers_count'] = count($data['orders']);
        $data['defaut'] = false;
        return view('bv_pending_orders', $data);
    }


    public function bv_confirmed_orders()
    {
        $db = \Config\Database::connect();
        $data = $this->get_head_sidebar();
        $data['TITLE'] = 'BV Confirmed Orders';
        $data['err'] = false;
        $data['msg'] = "";
        $date = date('Y-m-d');
        $sql = "SELECT ad.username, ad2.username as username2, cb.ampm,cb.id, cb.user_id, cb.cancel, cb.canceled_by, cb.accepted_by, cb.farmer_id, cb.farmer_phone, cb.order_id, cb.order_date, cb.order_quantity, cb.order_confirm, cb.lot_number, cb.order_currect_date, cb.category, cb.indent_moult, cb.indent_type, cb.on_behalf, cb.chawki_id,t.farmer_name,t.farmer_fathername,t.village_name, t.district_name, t.taluk_name, t.survey_center FROM bv_orders cb INNER JOIN tbl_info t on t.phone=cb.farmer_phone INNER JOIN adminlogin ad on ad.id=cb.user_id LEFT JOIN adminlogin ad2 ON ad2.id = cb.accepted_by where 1=1 and order_confirm='Confirmed' and cb.distributed='0 'and order_date= ".$date." Order by id DESC";
        $query = $db->query($sql);
        $data['orders'] = $query->getResultArray();
        $data['farmers_count'] = count($data['orders']);

        return view('bv_confirmed_orders', $data);
    }

    public function bv_confirmed_orders_post()
    {
        $db = \Config\Database::connect();
        $data = $this->get_head_sidebar();
        $data['TITLE'] = 'BV Confirmed Orders';
        $data['msg'] = '';
        $data['defaut'] = false;
        $data['err'] = false;


        if (isset($_POST['newConfirm'])) {
            $db_d = $this->request->getPost('db');
            $date = $this->request->getPost('date');
            $qty = $this->request->getPost('qty');
            $ampm = $this->request->getPost('ampm');
            $id = $this->request->getPost('id');
            $sql = "update $db_d set order_date='$date', order_quantity='$qty',ampm='$ampm' where id='$id'";
            $query = $db->query($sql);
            if ($query) {
                session()->setFlashdata('msg', 'Order reconfirmed!');
                return redirect()->to('admin/bv-confirmed-orders');
            } else {
                session()->setFlashdata('msg', 'Something Went Wrong!');
                return redirect()->to('admin/bv-confirmed-orders');
            }
        }


        if (isset($_POST['newDistribute'])) {
            $db_d = $this->request->getPost('db');
            $date = $this->request->getPost('date');
            $qty = $this->request->getPost('qty');
            $ampm = $this->request->getPost('ampm');
            $id = $this->request->getPost('id');
            $sql = "update $_POST[db] set order_date='$_POST[date]', order_quantity='$_POST[qty]',distributed='1',ampm='$_POST[ampm]' where id='$_POST[id]'";
            $query = $db->query($sql);
            if ($query) {
                session()->setFlashdata('msg', 'Order distributed!');
                return redirect()->to('admin/bv-confirmed-orders');
            } else {
                session()->setFlashdata('msg', 'Something Went Wrong!');
                return redirect()->to('admin/bv-confirmed-orders');
            }
        }


        // Base query
        $db = \Config\Database::connect(); // Ensure database connection is established
        $sql = "SELECT ad.username, ad2.username as username2, cb.ampm,cb.id, cb.user_id, cb.cancel, cb.canceled_by, cb.accepted_by, cb.farmer_id, cb.farmer_phone, cb.order_id, cb.order_date, cb.order_quantity, cb.order_confirm, cb.lot_number, cb.order_currect_date, cb.category, cb.indent_moult, cb.indent_type, cb.on_behalf, cb.chawki_id,t.farmer_name,t.farmer_fathername,t.village_name, t.district_name, t.taluk_name, t.survey_center FROM bv_orders cb INNER JOIN tbl_info t on t.phone=cb.farmer_phone INNER JOIN adminlogin ad on ad.id=cb.user_id LEFT JOIN adminlogin ad2 ON ad2.id = cb.accepted_by  where 1=1 and order_confirm='Confirmed' and cb.distributed='0' ";

        // Apply filters if `filterCb` is set
        if (isset($_POST['filterCb'])) {
            // Handle fromDate filter
            if ($fromDate = $this->request->getPost('fromDate')) {
                $dateType = $this->request->getPost('dateType');
                $column = ($dateType && $dateType == 1) ? 'cb.order_date' : 'cb.order_currect_date';
                $sql .= " and $column >= '$fromDate'";
            }

            // Handle toDate filter
            if ($toDate = $this->request->getPost('toDate')) {
                $dateType = $this->request->getPost('dateType');
                $column = ($dateType && $dateType == 1) ? 'cb.order_date' : 'cb.order_currect_date';
                $sql .= " and $column <= '$toDate'";
            }

            // Handle type filter
            if ($type = $this->request->getPost('type')) {
                if ($type !== "All") {
                    $sql .= " and (cb.category = '$type' or cb.on_behalf = '$type')";
                }
            }

            // Handle AM/PM filter
            if ($ampm = $this->request->getPost('ampm')) {
                if ($ampm !== "All") {
                    $sql .= " and cb.ampm = '$ampm'";
                }
            }

            $sql .= " Order by id DESC";


            $query = $db->query($sql);
            $result = $query->getResultArray(); 
            $data['orders'] = $result;
            $data['farmers_count'] = count($result);

            return view('bv_confirmed_orders', $data);
        }

        if (isset($_POST['takeAction'])) {
            $action = $this->request->getPost('action');
            $id = $this->request->getPost('id');
            $dbTable = $this->request->getPost('db');
            $farmerId = $this->request->getPost('farmer_id');

            // Determine confirmation status
            $c = ($action == 'confirm') ? 'Confirmed' : 'Canceled';

            // Update the order status
            $sql = "UPDATE `$dbTable` SET order_confirm = ? WHERE id = ?";
            $query = $db->query($sql, [$c, $id]);

            if ($query) {
                if ($c == 'Confirmed') {
                    // Set indent based on the database table
                    $indent = ($dbTable == 'bv_orders') ? 'CB' : 'BV';

                    // Prepare notification data
                    $title = "$indent Order Confirmed";
                    $body = "Your order has been confirmed.";
                    $page = "Order";

                    // Insert notification into Notification_farmer table
                    $notificationData = [
                        'farmer_id' => $farmerId,
                        'title' => $title,
                        'body' => $body,
                        'page' => $page
                    ];
                    $db->table('Notification_farmer')->insert($notificationData);
                }

                $msg = "Order Status Updated!";
            } else {
                $msg = "Something Went Wrong!";
                $err = true;
            }

            // Optionally return response
            return $this->response->setJSON([
                'message' => $msg,
                'error' => isset($err) ? $err : false
            ]);
        }
    }

    public function bv_cancelled_orders()
    {

        $db = \Config\Database::connect();
        $data = $this->get_head_sidebar();
        $data['TITLE'] = 'BV Cancelled Orders';
        $data['err'] = false;
        $data['msg'] = "";
        $date = date('Y-m-d');
        $sql = "SELECT ad.username, ad2.username as username2, cb.ampm,cb.id, cb.user_id,cb.cancel, cb.canceled_by, cb.accepted_by, cb.farmer_id, cb.farmer_phone, cb.order_id, cb.order_date, cb.order_quantity, cb.order_confirm, cb.lot_number, cb.order_currect_date, cb.category, cb.indent_moult, cb.indent_type, cb.on_behalf, cb.chawki_id,t.farmer_name,t.farmer_fathername,t.village_name, t.district_name, t.taluk_name, t.survey_center FROM bv_orders cb INNER JOIN tbl_info t on t.phone=cb.farmer_phone INNER JOIN adminlogin ad on ad.id=cb.user_id LEFT JOIN adminlogin ad2 ON ad2.id = cb.accepted_by  where 1=1 and order_confirm='Canceled' and order_currect_date>= ".$date." Order by id DESC";



        $query = $db->query($sql);
        $result = $query->getResultArray();
        $data['orders'] = $result;
        $data['farmers_count'] = count($result);

        return view('bv_cancelled_orders', $data);
    }

    public function bv_cancelled_orders_post()
    {
        $db = \Config\Database::connect();
        $data = $this->get_head_sidebar();
        $data['TITLE'] = 'BV Cancelled Orders';
        $data['msg'] = '';
        $data['err'] = false;
        $data['defaut'] = false;

        $sql = "SELECT ad.username, ad2.username as username2, cb.ampm,cb.id, cb.user_id,cb.cancel, cb.canceled_by, cb.accepted_by, cb.farmer_id, cb.farmer_phone, cb.order_id, cb.order_date, cb.order_quantity, cb.order_confirm, cb.lot_number, cb.order_currect_date, cb.category, cb.indent_moult, cb.indent_type, cb.on_behalf, cb.chawki_id,t.farmer_name,t.farmer_fathername,t.village_name, t.district_name, t.taluk_name, t.survey_center FROM bv_orders cb INNER JOIN tbl_info t on t.phone=cb.farmer_phone INNER JOIN adminlogin ad on ad.id=cb.user_id LEFT JOIN adminlogin ad2 ON ad2.id = cb.accepted_by where 1=1 and order_confirm='Canceled'";

        if (isset($_POST['filterCb'])):
            if (isset($_POST['fromDate']) && !empty($_POST['fromDate'])):
                if (isset($_POST['dateType']) && !empty($_POST['dateType'])):
                    if ($_POST['dateType'] == 0):
                        $type = "`order_currect_date`";
                    else:
                        $type = "`order_date`";
                    endif;
                else:
                    $type = "`order_currect_date`";
                endif;

                $sql .= " and $type>='$_POST[fromDate]'";
            endif;

            if (isset($_POST['toDate']) && !empty($_POST['toDate'])):
                if (isset($_POST['dateType']) && !empty($_POST['dateType'])):
                    if ($_POST['dateType'] == 0):
                        $type = "`order_currect_date`";
                    else:
                        $type = "`order_date`";
                    endif;
                else:
                    $type = "`order_currect_date`";
                endif;

                $sql .= " and $type<='$_POST[toDate]'";
            endif;


            if (isset($_POST['type']) && $_POST['type'] != "All"):
                $sql .= " and category='$_POST[type]' or on_behalf='$_POST[type]'";
            endif;

            if (isset($_POST['ampm']) && $_POST['ampm'] != "All"):
                $sql .= " and ampm='$_POST[ampm]'";
            endif;
        endif;

        $sql .= " ORDER BY id DESC";

        $db = \Config\Database::connect();

        $query = $db->query($sql);
        $result = $query->getResultArray();
        $data['orders'] = $result;
        $data['farmers_count'] = count($result);

        return view('bv_cancelled_orders', $data);
    }


    public function bv_distributed_orders(){
        $db = \Config\Database::connect();
        $data = $this->get_head_sidebar();


        if (isset($_POST['newConfirm'])) {
            $db_d = $this->request->getPost('db');
            $date = $this->request->getPost('date');
            $qty = $this->request->getPost('qty');
            $ampm = $this->request->getPost('ampm');
            $id = $this->request->getPost('id');
            $sql = "update $db_d set order_date='$date', order_quantity='$qty',ampm='$ampm' where id='$id'";
            $query = $db->query($sql);
            if ($query) {
                session()->setFlashdata('msg', 'Order reconfirmed!');
                return redirect()->to('admin/bv-distributed-orders');
            } else {
                session()->setFlashdata('msg', 'Something Went Wrong!');
                return redirect()->to('admin/bv-distributed-orders');
            }
        }


        $data['TITLE'] = 'BV Distributed Orders';
        $data['err'] = false;
        $data['msg'] = "";
        $data['defaut'] = false;
        $date = date('Y-m-d');
        $sql = "SELECT ad.username, ad2.username as username2, cb.ampm,cb.id, cb.user_id, cb.canceled_by, cb.accepted_by, cb.farmer_id, cb.farmer_phone, cb.order_id, cb.order_date, cb.order_quantity, cb.order_confirm, cb.lot_number, cb.order_currect_date, cb.category, cb.indent_moult, cb.indent_type, cb.on_behalf, cb.chawki_id,t.farmer_name,t.farmer_fathername,t.village_name, t.district_name, t.taluk_name, t.survey_center FROM bv_orders cb INNER JOIN tbl_info t on t.phone=cb.farmer_phone INNER JOIN adminlogin ad on ad.id=cb.user_id LEFT JOIN adminlogin ad2 ON ad2.id = cb.accepted_by   where 1=1 and order_confirm='Confirmed' and cb.distributed='1' and order_currect_date= ".$date." Order by id DESC";
        $query = $db->query($sql);
        $data['orders'] = $query->getResultArray();
        $data['farmers_count'] = count($data['orders']);
        return view('bv_distributed', $data);
    }

    public function bv_distributed_orders_post(){
        $db = \Config\Database::connect();
        $data = $this->get_head_sidebar();
        $data['TITLE'] = 'BV Distributed Orders';
        $data['err'] = false;
        $data['msg'] = "";
        $data['defaut'] = false;

        $sql = "SELECT ad.username, ad2.username as username2, cb.ampm,cb.id, cb.user_id, cb.canceled_by, cb.accepted_by, cb.farmer_id, cb.farmer_phone, cb.order_id, cb.order_date, cb.order_quantity, cb.order_confirm, cb.lot_number, cb.order_currect_date, cb.category, cb.indent_moult, cb.indent_type, cb.on_behalf, cb.chawki_id,t.farmer_name,t.farmer_fathername,t.village_name, t.district_name, t.taluk_name, t.survey_center FROM bv_orders cb INNER JOIN tbl_info t on t.phone=cb.farmer_phone INNER JOIN adminlogin ad on ad.id=cb.user_id LEFT JOIN adminlogin ad2 ON ad2.id = cb.accepted_by  where 1=1 and order_confirm='Confirmed' and cb.distributed='1'";

        if (isset($_POST['newConfirm'])) {
            $db_d = $this->request->getPost('db');
            $date = $this->request->getPost('date');
            $qty = $this->request->getPost('qty');
            $ampm = $this->request->getPost('ampm');
            $id = $this->request->getPost('id');
            $sql = "update $db_d set order_date='$date', order_quantity='$qty',ampm='$ampm' where id='$id'";
            $query = $db->query($sql);
            if ($query) {
                session()->setFlashdata('msg', 'Order reconfirmed!');
                return redirect()->to('admin/bv-distributed-orders');
            } else {
                session()->setFlashdata('msg', 'Something Went Wrong!');
                return redirect()->to('admin/bv-distributed-orders');
            }
        }

        if(isset($_POST['filterCb'])):
            if(isset($_POST['fromDate']) && !empty($_POST['fromDate'])):
                if(isset($_POST['dateType']) && !empty($_POST['dateType'])):
                    if($_POST['dateType'] == 0):
                        $type = "`order_currect_date`";
                    else:
                        $type = "`order_date`";
                    endif;
                else:
                    $type = "`order_currect_date`";
                endif;
                
                $sql .= " and $type>='$_POST[fromDate]'";
            endif;
            
            if(isset($_POST['toDate']) && !empty($_POST['toDate'])):
                if(isset($_POST['dateType']) && !empty($_POST['dateType'])):
                    if($_POST['dateType'] == 0):
                        $type = "`order_currect_date`";
                    else:
                        $type = "`order_date`";
                    endif;
                else:
                    $type = "`order_currect_date`";
                endif;
                
                $sql .= " and $type<='$_POST[toDate]'";
            endif;
            
            
            // if(isset($_POST['type']) && $_POST['type'] != "All"):
            //     $sql .= " and category='$_POST[type]'";
            // endif;
                
            if(isset($_POST['ampm']) && $_POST['ampm'] != "All"):
                $sql .= " and ampm='$_POST[ampm]'";
            endif;
        endif;

        $sql .= " ORDER BY id DESC";

        $query = $db->query($sql);
        $data['orders'] = $query->getResultArray();
        $data['farmers_count'] = count($data['orders']);
        return view('bv_distributed', $data);
    }























    ////////

    public function cb_pending_orders()
    {
        $db = \Config\Database::connect();
        $data = $this->get_head_sidebar();
        $data['TITLE'] = 'CB Pending Orders';
        $data['err'] = false;
        $data['msg'] = "";
        $date = date('Y-m-d');
        $sql = "SELECT ad.username, cb.ampm,cb.id, cb.user_id, cb.canceled_by, cb.accepted_by, cb.farmer_id, cb.farmer_phone, cb.order_id, cb.order_date, cb.order_quantity, cb.order_confirm, cb.lot_number, cb.order_currect_date, cb.category, cb.indent_moult, cb.indent_type, cb.on_behalf, cb.chawki_id,t.farmer_name,t.farmer_fathername,t.village_name, t.district_name, t.taluk_name, t.survey_center FROM cb_orders cb INNER JOIN tbl_info t on t.phone=cb.farmer_phone INNER JOIN adminlogin ad on ad.id=cb.user_id where 1=1 and order_confirm='Not Confirmed' and order_currect_date>= ".$date." Order by id DESC";
        $query = $db->query($sql);
        $data['orders'] = $query->getResultArray();
        $data['farmers_count'] = count($data['orders']);

        return view('cb_pending_orders', $data);
    }

    public function cb_pending_orders_post()
    {
        $db = \Config\Database::connect();
        $data = $this->get_head_sidebar();
        $data['msg'] = '';
        $data['err'] = false;
        $data['TITLE'] = 'CB Pending Orders';

        $sql = "";

        if (isset($_POST['filterCb'])) {

            $sql = "SELECT ad.username, cb.ampm,cb.id, cb.user_id, cb.canceled_by, cb.accepted_by, cb.farmer_id, cb.farmer_phone, cb.order_id, cb.order_date, cb.order_quantity, cb.order_confirm, cb.lot_number, cb.order_currect_date, cb.category, cb.indent_moult, cb.indent_type, cb.on_behalf, cb.chawki_id,t.farmer_name,t.farmer_fathername,t.village_name, t.district_name, t.taluk_name, t.survey_center FROM cb_orders cb INNER JOIN tbl_info t on t.phone=cb.farmer_phone INNER JOIN adminlogin ad on ad.id=cb.user_id where 1=1 and order_confirm='Not Confirmed'";
            if (isset($_POST['fromDate']) && !empty($_POST['fromDate'])) {
                if (isset($_POST['dateType']) && !empty($_POST['dateType'])) {
                    if ($this->request->getPost('dateType') == 0) {
                        $type = "`order_currect_date`";
                    } else {
                        $type = "`order_date`";
                    }
                } else {
                    $type = "`order_currect_date`";
                }
                $sql .= " and $type>='{$this->request->getPost('fromDate')}'";
            }

            if (isset($_POST["toDate"]) && !empty($_POST['toDate'])) {
                if (isset($_POST['dateType']) && !empty($_POST['dateType'])) {
                    if ($this->request->getPost('dateType') == 0) {
                        $type = "`order_currect_date`";
                    } else {
                        $type = "`order_date`";
                    }
                } else {
                    $type = "`order_currect_date`";
                }
                $sql .= " and $type<='{$this->request->getPost('toDate')}'";
            }
            if (isset($_POST["type"]) && $this->request->getPost("type") != 'All') {
                $sql .= " and category='{$this->request->getPost('type')}' or on_behalf='{$this->request->getPost('type')}'";
            }
            if (isset($_POST["ampm"]) && $this->request->getPost("ampm") != "All") {
                $sql .= " and ampm='{$this->request->getPost('ampm')}'";
            }
        }

        $sql .= " Order by id DESC";

        $query = $db->query($sql);

        $data['orders'] = $query->getResultArray();
        $data['farmers_count'] = count($data['orders']);
        $data['defaut'] = false;
        return view('cb_pending_orders', $data);
    }


    public function cb_confirmed_orders()
    {
        $db = \Config\Database::connect();
        $data = $this->get_head_sidebar();
        $data['TITLE'] = 'CB Confirmed Orders';
        $data['err'] = false;
        $data['msg'] = "";
        $date = date('Y-m-d');
        $sql = "SELECT ad.username, ad2.username as username2, cb.ampm,cb.id, cb.user_id, cb.cancel, cb.canceled_by, cb.accepted_by, cb.farmer_id, cb.farmer_phone, cb.order_id, cb.order_date, cb.order_quantity, cb.order_confirm, cb.lot_number, cb.order_currect_date, cb.category, cb.indent_moult, cb.indent_type, cb.on_behalf, cb.chawki_id,t.farmer_name,t.farmer_fathername,t.village_name, t.district_name, t.taluk_name, t.survey_center FROM cb_orders cb INNER JOIN tbl_info t on t.phone=cb.farmer_phone INNER JOIN adminlogin ad on ad.id=cb.user_id LEFT JOIN adminlogin ad2 ON ad2.id = cb.accepted_by  where 1=1 and order_confirm='Confirmed' and cb.distributed='0' and  order_date= ".$date." Order by id DESC";
        $query = $db->query($sql);
        $data['orders'] = $query->getResultArray();
        $data['farmers_count'] = count($data['orders']);

        return view('cb_confirmed_orders', $data);
    }

    public function cb_confirmed_orders_post()
    {
        $db = \Config\Database::connect();
        $data = $this->get_head_sidebar();
        $data['TITLE'] = 'CB Confirmed Orders';
        $data['msg'] = '';
        $data['defaut'] = false;
        $data['err'] = false;


        if (isset($_POST['newConfirm'])) {
            $db_d = $this->request->getPost('db');
            $date = $this->request->getPost('date');
            $qty = $this->request->getPost('qty');
            $ampm = $this->request->getPost('ampm');
            $id = $this->request->getPost('id');
            $sql = "update $db_d set order_date='$date', order_quantity='$qty',ampm='$ampm' where id='$id'";
            $query = $db->query($sql);
            if ($query) {
                session()->setFlashdata('msg', 'Order reconfirmed!');
                return redirect()->to('admin/cb-confirmed-orders');
            } else {
                session()->setFlashdata('msg', 'Something Went Wrong!');
                return redirect()->to('admin/cb-confirmed-orders');
            }
        }


        if (isset($_POST['newDistribute'])) {
            $db_d = $this->request->getPost('db');
            $date = $this->request->getPost('date');
            $qty = $this->request->getPost('qty');
            $ampm = $this->request->getPost('ampm');
            $id = $this->request->getPost('id');
            $sql = "update $_POST[db] set order_date='$_POST[date]', order_quantity='$_POST[qty]',distributed='1',ampm='$_POST[ampm]' where id='$_POST[id]'";
            $query = $db->query($sql);
            if ($query) {
                session()->setFlashdata('msg', 'Order distributed!');
                return redirect()->to('admin/cb-confirmed-orders');
            } else {
                session()->setFlashdata('msg', 'Something Went Wrong!');
                return redirect()->to('admin/cb-confirmed-orders');
            }
        }


        // Base query
        $db = \Config\Database::connect(); // Ensure database connection is established
        $sql = "SELECT ad.username, ad2.username as username2, cb.ampm,cb.id, cb.user_id, cb.cancel, cb.canceled_by, cb.accepted_by, cb.farmer_id, cb.farmer_phone, cb.order_id, cb.order_date, cb.order_quantity, cb.order_confirm, cb.lot_number, cb.order_currect_date, cb.category, cb.indent_moult, cb.indent_type, cb.on_behalf, cb.chawki_id,t.farmer_name,t.farmer_fathername,t.village_name, t.district_name, t.taluk_name, t.survey_center FROM cb_orders cb INNER JOIN tbl_info t on t.phone=cb.farmer_phone INNER JOIN adminlogin ad on ad.id=cb.user_id LEFT JOIN adminlogin ad2 ON ad2.id = cb.accepted_by  where 1=1 and order_confirm='Confirmed' and cb.distributed='0' ";

        // Apply filters if `filterCb` is set
        if (isset($_POST['filterCb'])) {
            // Handle fromDate filter
            if ($fromDate = $this->request->getPost('fromDate')) {
                $dateType = $this->request->getPost('dateType');
                $column = ($dateType && $dateType == 1) ? 'cb.order_date' : 'cb.order_currect_date';
                $sql .= " and $column >= '$fromDate'";
            }

            // Handle toDate filter
            if ($toDate = $this->request->getPost('toDate')) {
                $dateType = $this->request->getPost('dateType');
                $column = ($dateType && $dateType == 1) ? 'cb.order_date' : 'cb.order_currect_date';
                $sql .= " and $column <= '$toDate'";
            }

            // Handle type filter
            if ($type = $this->request->getPost('type')) {
                if ($type !== "All") {
                    $sql .= " and (cb.category = '$type' or cb.on_behalf = '$type')";
                }
            }

            // Handle AM/PM filter
            if ($ampm = $this->request->getPost('ampm')) {
                if ($ampm !== "All") {
                    $sql .= " and cb.ampm = '$ampm'";
                }
            }

            $sql .= " Order by id DESC";


            $query = $db->query($sql);
            $result = $query->getResultArray(); 
            $data['orders'] = $result;
            $data['farmers_count'] = count($result);

            return view('cb_confirmed_orders', $data);
        }



        if (isset($_POST['takeAction'])) {
            $action = $this->request->getPost('action');
            $id = $this->request->getPost('id');
            $dbTable = $this->request->getPost('db');
            $farmerId = $this->request->getPost('farmer_id');

            // Determine confirmation status
            $c = ($action == 'confirm') ? 'Confirmed' : 'Canceled';

            // Update the order status
            $sql = "UPDATE `$dbTable` SET order_confirm = ? WHERE id = ?";
            $query = $db->query($sql, [$c, $id]);

            if ($query) {
                if ($c == 'Confirmed') {
                    // Set indent based on the database table
                    $indent = ($dbTable == 'cb_orders') ? 'CB' : 'BV';

                    // Prepare notification data
                    $title = "$indent Order Confirmed";
                    $body = "Your order has been confirmed.";
                    $page = "Order";

                    // Insert notification into Notification_farmer table
                    $notificationData = [
                        'farmer_id' => $farmerId,
                        'title' => $title,
                        'body' => $body,
                        'page' => $page
                    ];
                    $db->table('Notification_farmer')->insert($notificationData);
                }

                $msg = "Order Status Updated!";
            } else {
                $msg = "Something Went Wrong!";
                $err = true;
            }

            // Optionally return response
            return $this->response->setJSON([
                'message' => $msg,
                'error' => isset($err) ? $err : false
            ]);
        }
    }

    public function cb_cancelled_orders()
    {

        $db = \Config\Database::connect();
        $data = $this->get_head_sidebar();
        $data['TITLE'] = 'CB Cancelled Orders';
        $data['err'] = false;
        $data['msg'] = "";
        $date = date('Y-m-d');
        $sql = "SELECT ad.username, ad2.username as username2, cb.ampm,cb.id, cb.user_id,cb.cancel, cb.canceled_by, cb.accepted_by, cb.farmer_id, cb.farmer_phone, cb.order_id, cb.order_date, cb.order_quantity, cb.order_confirm, cb.lot_number, cb.order_currect_date, cb.category, cb.indent_moult, cb.indent_type, cb.on_behalf, cb.chawki_id,t.farmer_name,t.farmer_fathername,t.village_name, t.district_name, t.taluk_name, t.survey_center FROM cb_orders cb INNER JOIN tbl_info t on t.phone=cb.farmer_phone INNER JOIN adminlogin ad on ad.id=cb.user_id LEFT JOIN adminlogin ad2 ON ad2.id = cb.accepted_by  where 1=1 and order_confirm='Canceled' and order_currect_date>= ".$date." Order by id DESC";



        $query = $db->query($sql);
        $result = $query->getResultArray();
        $data['orders'] = $result;
        $data['farmers_count'] = count($result);

        return view('cb_cancelled_orders', $data);
    }

    public function cb_cancelled_orders_post()
    {
        $db = \Config\Database::connect();
        $data = $this->get_head_sidebar();
        $data['TITLE'] = 'CB Cancelled Orders';
        $data['msg'] = '';
        $data['err'] = false;
        $data['defaut'] = false;

        $sql = "SELECT ad.username, ad2.username as username2, cb.ampm,cb.id, cb.user_id,cb.cancel, cb.canceled_by, cb.accepted_by, cb.farmer_id, cb.farmer_phone, cb.order_id, cb.order_date, cb.order_quantity, cb.order_confirm, cb.lot_number, cb.order_currect_date, cb.category, cb.indent_moult, cb.indent_type, cb.on_behalf, cb.chawki_id,t.farmer_name,t.farmer_fathername,t.village_name, t.district_name, t.taluk_name, t.survey_center FROM cb_orders cb INNER JOIN tbl_info t on t.phone=cb.farmer_phone INNER JOIN adminlogin ad on ad.id=cb.user_id LEFT JOIN adminlogin ad2 ON ad2.id = cb.accepted_by where 1=1 and order_confirm='Canceled'";

        if (isset($_POST['filterCb'])):
            if (isset($_POST['fromDate']) && !empty($_POST['fromDate'])):
                if (isset($_POST['dateType']) && !empty($_POST['dateType'])):
                    if ($_POST['dateType'] == 0):
                        $type = "`order_currect_date`";
                    else:
                        $type = "`order_date`";
                    endif;
                else:
                    $type = "`order_currect_date`";
                endif;

                $sql .= " and $type>='$_POST[fromDate]'";
            endif;

            if (isset($_POST['toDate']) && !empty($_POST['toDate'])):
                if (isset($_POST['dateType']) && !empty($_POST['dateType'])):
                    if ($_POST['dateType'] == 0):
                        $type = "`order_currect_date`";
                    else:
                        $type = "`order_date`";
                    endif;
                else:
                    $type = "`order_currect_date`";
                endif;

                $sql .= " and $type<='$_POST[toDate]'";
            endif;


            if (isset($_POST['type']) && $_POST['type'] != "All"):
                $sql .= " and cb.category= '$_POST[type]' or on_behalf='$_POST[type]'";
            endif;

            if (isset($_POST['ampm']) && $_POST['ampm'] != "All"):
                $sql .= " and ampm='$_POST[ampm]'";
            endif;
        endif;

        $sql .= " ORDER BY id DESC";

        $db = \Config\Database::connect();


        $query = $db->query($sql);
        $result = $query->getResultArray();
        $data['orders'] = $result;
        $data['farmers_count'] = count($result);

        return view('cb_cancelled_orders', $data);
    }


    public function cb_distributed_orders(){
        if (isset($_POST['newConfirm'])) {
            $db_d = $this->request->getPost('db');
            $date = $this->request->getPost('date');
            $qty = $this->request->getPost('qty');
            $ampm = $this->request->getPost('ampm');
            $id = $this->request->getPost('id');
            $sql = "update $db_d set order_date='$date', order_quantity='$qty',ampm='$ampm' where id='$id'";
            $query = $db->query($sql);
            if ($query) {
                session()->setFlashdata('msg', 'Order reconfirmed!');
                return redirect()->to('admin/cb-confirmed-orders');
            } else {
                session()->setFlashdata('msg', 'Something Went Wrong!');
                return redirect()->to('admin/cb-confirmed-orders');
            }
        }
        $db = \Config\Database::connect();
        $data = $this->get_head_sidebar();
        $data['TITLE'] = 'CB Distributed Orders';
        $data['err'] = false;
        $data['msg'] = "";
        $data['defaut'] = false;
        $date = date('Y-m-d');
        $sql = "SELECT ad.username, ad2.username as username2, cb.ampm,cb.id, cb.user_id, cb.canceled_by, cb.accepted_by, cb.farmer_id, cb.farmer_phone, cb.order_id, cb.order_date, cb.order_quantity, cb.order_confirm, cb.lot_number, cb.order_currect_date, cb.category, cb.indent_moult, cb.indent_type, cb.on_behalf, cb.chawki_id,t.farmer_name,t.farmer_fathername,t.village_name, t.district_name, t.taluk_name, t.survey_center FROM cb_orders cb INNER JOIN tbl_info t on t.phone=cb.farmer_phone INNER JOIN adminlogin ad on ad.id=cb.user_id LEFT JOIN adminlogin ad2 ON ad2.id = cb.accepted_by where 1=1 and order_confirm='Confirmed' and cb.distributed='1'and order_currect_date= ".$date." Order by id DESC";
        $query = $db->query($sql);
        $data['orders'] = $query->getResultArray();
        $data['farmers_count'] = count($data['orders']);


        return view('cb_distributed', $data);
    }

    public function cb_distributed_orders_post(){
        $db = \Config\Database::connect();
        $data = $this->get_head_sidebar();
        $data['TITLE'] = 'CB Distributed Orders';
        $data['msg'] = '';
        $data['err'] = false;
        $data['defaut'] = false;

        $sql = "SELECT ad.username, ad2.username as username2, cb.ampm,cb.id, cb.user_id, cb.canceled_by, cb.accepted_by, cb.farmer_id, cb.farmer_phone, cb.order_id, cb.order_date, cb.order_quantity, cb.order_confirm, cb.lot_number, cb.order_currect_date, cb.category, cb.indent_moult, cb.indent_type, cb.on_behalf, cb.chawki_id,t.farmer_name,t.farmer_fathername,t.village_name, t.district_name, t.taluk_name, t.survey_center FROM cb_orders cb INNER JOIN tbl_info t on t.phone=cb.farmer_phone INNER JOIN adminlogin ad on ad.id=cb.user_id LEFT JOIN adminlogin ad2 ON ad2.id = cb.accepted_by where 1=1 and order_confirm='Confirmed' and cb.distributed='1'";
                        
        
        if (isset($_POST['newConfirm'])) {
            $db_d = $this->request->getPost('db');
            $date = $this->request->getPost('date');
            $qty = $this->request->getPost('qty');
            $ampm = $this->request->getPost('ampm');
            $id = $this->request->getPost('id');
            $sql = "update $db_d set order_date='$date', order_quantity='$qty',ampm='$ampm' where id='$id'";
            $query = $db->query($sql);
            if ($query) {
                session()->setFlashdata('msg', 'Order reconfirmed!');
                return redirect()->to('admin/cb-distributed-orders');
            } else {
                session()->setFlashdata('msg', 'Something Went Wrong!');
                return redirect()->to('admin/bv-distributed-orders');
            }
        }
        if(isset($_POST['filterCb'])):
            if(isset($_POST['fromDate']) && !empty($_POST['fromDate'])):
                if(isset($_POST['dateType']) && !empty($_POST['dateType'])):
                    if($_POST['dateType'] == 0):
                        $type = "`order_currect_date`";
                    else:
                        $type = "`order_date`";
                    endif;
                else:
                    $type = "`order_currect_date`";
                endif;
                
                $sql .= " and $type>='$_POST[fromDate]'";
            endif;
            
            if(isset($_POST['toDate']) && !empty($_POST['toDate'])):
                if(isset($_POST['dateType']) && !empty($_POST['dateType'])):
                    if($_POST['dateType'] == 0):
                        $type = "`order_currect_date`";
                    else:
                        $type = "`order_date`";
                    endif;
                else:
                    $type = "`order_currect_date`";
                endif;
                
                $sql .= " and $type<='$_POST[toDate]'";
            endif;
            
            
            // if(isset($_POST['type']) && $_POST['type'] != "All"):
            //     $sql .= " and category='$_POST[type]'";
            // endif;
                
            if(isset($_POST['ampm']) && $_POST['ampm'] != "All"):
                $sql .= " and ampm='$_POST[ampm]'";
            endif;
        endif;

        $sql .= " ORDER BY id DESC";

        $query = $db->query($sql);
        $data['orders'] = $query->getResultArray();
        $data['farmers_count'] = count($data['orders']);
        return view('cb_distributed', $data);
    
    }

    public function print_bill(){
        $data = $this->get_head_sidebar();
        $data['TITLE'] = 'Print Bill';
        $data['err'] = false;
        $data['msg'] = '';
        $data['default'] = false;

        $db = \Config\Database::connect();

        $sql = "CREATE TABLE IF NOT EXISTS `invoice_data` (
            `id` int(11) NOT NULL AUTO_INCREMENT,
            `order_id` varchar(255)  NULL,
            `order_table` varchar(255)  NULL,
            `farmer_id` varchar(255)  NULL,
            `owner_name` varchar(255)  NULL,
            `race` varchar(255)  NULL,
            `source` varchar(255)  NULL,
            `price` varchar(255)  NULL,
            `bonus` varchar(255)  NULL,
            `old_due` varchar(255)  NULL,
            PRIMARY KEY (`id`)
          ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
    
        $db->query($sql);

        $id = $this->request->getGet('id');
        $db_table = $this->request->getGet('db');
        if($id && $db_table){
            $sql = "select * from invoice_data where order_id='$id' and order_table='$db_table'";
            $query = $db->query($sql);
            $result = $query->getResultArray();
            if(count($result) > 0){
                $data['order'] = $result[0];
            }
        }

        return view('print_bill', $data);
    }

    public function printBillTemplate(){
        if(!isset($_POST['id']) or !isset($_POST['db'])):
            die;
        endif;

        
        $db = \Config\Database::connect();
        
        $order_sql = "select * from $_POST[db] where id='$_POST[id]'";
        

        $order_result = $db->query($order_sql)->getResultArray();
        $farmer_sql = "select * from tbl_info where farmer_id='".$order_result[0]['farmer_id']."'";
        $farmer_result = $db->query($farmer_sql)->getResultArray();

        $dataDb ='';
        if($_POST['db'] == "cb_orders"):
            $dataDb = "cb_data";
        else:
            $dataDb = "bv_data";
        endif;

        $DATA_sql = "select * from ".$dataDb." where `availabledata`='".$order_result[0]['order_date']."' and `lot_number`='".$order_result[0]['lot_number']."'";

        $ownername = $_POST['ownerName'];
        $race = $_POST['race'];
        $lot_number = $_POST['lotno'];
        $souce = $_POST['source'];
        $price = $_POST['price'];
        $bonus = $_POST['bonusdfls'];

        

        // if you dont get the data from invoice the insert else update

        $iv_sql = "select * from invoice_data where order_id='".$order_result[0]['id']."' and order_table='".$_POST['db']."'";
        $invoice = $db->query($iv_sql)->getResultArray();
        
        if(count($invoice) > 0){
            $sql = "UPDATE `invoice_data` 
                SET `owner_name`='".$ownername."', 
                    `race`='".$race."', 
                    `source`='".$souce."', 
                    `price`='".$price."', 
                    `bonus`='".$bonus."' 
                WHERE `order_id`='".$order_result[0]['id']."' 
                AND `order_table`='".$_POST['db']."'";
        $db->query($sql);
        
        }else{
        
        $sql = "INSERT INTO `invoice_data` 
                (`order_id`, `order_table`, `farmer_id`, `owner_name`, `race`, `source`, `price`, `bonus`, `old_due`) 
                VALUES 
                ('".$order_result[0]['id']."', 
                 '".$_POST['db']."', 
                 '".$order_result[0]['farmer_id']."', 
                 '".$ownername."', 
                 '".$race."', 
                 '".$souce."', 
                 '".$price."', 
                 '".$bonus."', 
                 'paid')";
        $qury=$db->query($sql);
        

        }

        $sql = "select * from invoice_data where order_id='".$order_result[0]['id']."' and order_table='".$_POST['db']."'";
        $invoice = $db->query($sql)->getResultArray();

        $DATA = count($db->query($DATA_sql)->getResultArray())>0 ? $db->query($DATA_sql)->getResultArray()[0] : ['hatchingdate'=>'unavailable'];

        $data=[
            'ORDER' => $order_result[0],
            'FARMER' => $farmer_result[0],
            'DATA' => $DATA,
            'ownername' => $ownername,
            'race' => $race,
            'souce'=> $souce,
            'price'=> $price,
            'bonus'=> $bonus,
            'lot_number' => $lot_number,
            'invoice_number' => $invoice[0]['id'],
        ];

        if(isset($_POST['oldConfirm'])){
            return view('print_templete_old', $data);
        }


        return view('print_bill_template', $data);

    }
}
