<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */
$routes->get('/', 'Home::index');

$routes->group(
    'admin', 
    ['namespace' => 'App\Controllers'], 
    function($routes){
        
        $routes->get('logout', 'DashboadController::logout');

        $routes->get('api/getFarmerDetails', 'DashboadController::getFarmerDetails');
        $routes->get('api/getIndentDetails', 'DashboadController::getIndentDetails');
        $routes->get('api/getFarmerOrders','DashboadController::getFarmerOrders');
        $routes->get('api/getSolDetails', 'DashboadController::getSolDetails');
        $routes->post('api/update-order', 'DashboadController::UpdateOrderApi');
        $routes->get('api/getEditData', 'DashboadController::getEditData');

        $routes->get('login/', 'DashboadController::login');
        $routes->post('login_post/','DashboadController::login_post');

        $routes->get('dashboard/', 'DashboadController::dashboard');
        $routes->post('dashboard/','DashboadController::dashboard_post');

        $routes->get('new-registration/', 'DashboadController::new_registration');
        $routes->post('new-registration/','DashboadController::new_registration_post');

        $routes->get('manual-orders/', 'DashboadController::manual_orders');
        $routes->post('manual-orders/', 'DashboadController::manual_orders');
        
        $routes->get('manage-user/', 'DashboadController::manage_user');
        $routes->post('manage-user/','DashboadController::manage_user_post');

        $routes->get('price-fixation/', 'DashboadController::price_fixation');
        $routes->post('price-fixation/','DashboadController::price_fixation_post');

        $routes->get('complaints/', 'DashboadController::complaints');
        $routes->post('complaints/','DashboadController::complaints_post');

        $routes->get('cacoon-yeilds-details/', 'DashboadController::cacoon_yeilds_details');
        $routes->post('cacoon-yeilds-details/','DashboadController::cacoon_yeilds_details_post');

        // reports
        $routes->get('indent-report/', 'DashboadController::indent_report');
        $routes->post('indent-report/', 'DashboadController::indent_report');

        $routes->get('yield-report/', 'DashboadController::yield_report');
        $routes->post('yield-report/', 'DashboadController::yield_report_post');

        $routes->get('complaints-report/', 'DashboadController::complaints_report');
        $routes->post('complaints-report/', 'DashboadController::complaints_report_post');




        $routes->get('setting/', 'DashboadController::setting');
        $routes->post('setting/','DashboadController::setting_post');



        // recieved orders
        //kcrc.co.in/admin/bv-cancelled-orders
        $routes->get('bv-cancelled-orders/', 'DashboadController::bv_cancelled_orders');
        $routes->post('bv-cancelled-orders/','DashboadController::bv_cancelled_orders_post');
        $routes->get('bv-confirmed-orders/', 'DashboadController::bv_confirmed_orders');
        $routes->post('bv-confirmed-orders/','DashboadController::bv_confirmed_orders_post');
        $routes->get('bv-distributed/', 'DashboadController::bv_distributed_orders');
        $routes->post('bv-distributed/','DashboadController::bv_distributed_orders_post');
        $routes->get('bv-pending-orders/', 'DashboadController::bv_pending_orders');
        $routes->post('bv-pending-orders/','DashboadController::bv_pending_orders_post');


        // cb orders--
        $routes->get('cb-pending-orders/', 'DashboadController::cb_pending_orders');
        $routes->post('cb-pending-orders/','DashboadController::cb_pending_orders_post');
        $routes->get('cb-confirmed-orders/', 'DashboadController::cb_confirmed_orders');
        $routes->post('cb-confirmed-orders/','DashboadController::cb_confirmed_orders_post');
        $routes->get('cb-cancelled-orders/', 'DashboadController::cb_cancelled_orders');
        $routes->post('cb-cancelled-orders','DashboadController::cb_cancelled_orders_post');
        $routes->get('cb-distributed/', 'DashboadController::cb_distributed_orders');
        $routes->post('cb-distributed','DashboadController::cb_distributed_orders_post');



        $routes->get('print-bill/', 'DashboadController::print_bill');
        $routes->post('printBillTemplate/index','DashboadController::printBillTemplate');
    }
);

