<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Neon Bubble Quest Admin Login</title>

  <!-- Tailwind CSS -->
  <script src="https://cdn.tailwindcss.com"></script>
  <script>
    tailwind.config = {
      theme: {
        extend: {
          colors: {
            primary: "#6366f1",
            secondary: "#8b5cf6",
          },
          fontFamily: {
            poppins: ['Poppins', 'sans-serif'],
          },
        },
      },
    };
  </script>

  <!-- Font Awesome -->
  <link
    rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css"
  />

  <style>
    body {
      font-family: 'Poppins', sans-serif;
      background: linear-gradient(135deg, #1e1b4b, #4f46e5, #7c3aed);
      background-size: 200% 200%;
      animation: gradientShift 10s ease infinite;
      overflow: hidden;
      min-height: 100vh;
      display: flex;
      align-items: center;
      justify-content: center;
    }

    @keyframes  gradientShift {
      0%, 100% { background-position: left top; }
      50% { background-position: right bottom; }
    }

    .glass-card {
      position: relative;
      backdrop-filter: blur(25px);
      background: rgba(255, 255, 255, 0.08);
      border: 1px solid rgba(255, 255, 255, 0.25);
      border-radius: 1.5rem;
      box-shadow: 0 10px 40px rgba(0, 0, 0, 0.4);
      transition: all 0.4s ease;
      transform: translateY(30px);
      opacity: 0;
      animation: slideUp 1s ease forwards;
    }

    @keyframes  slideUp {
      to {
        transform: translateY(0);
        opacity: 1;
      }
    }

    .glass-card:hover {
      transform: translateY(-5px) scale(1.02);
      box-shadow: 0 15px 45px rgba(99, 102, 241, 0.4);
    }

    .floating-bg {
      position: absolute;
      width: 500px;
      height: 500px;
      border-radius: 50%;
      filter: blur(150px);
      opacity: 0.5;
      z-index: 0;
      animation: float 8s ease-in-out infinite alternate;
    }

    .floating-bg.bg1 {
      background: #6366f1;
      top: -100px;
      left: -150px;
    }

    .floating-bg.bg2 {
      background: #8b5cf6;
      bottom: -100px;
      right: -150px;
      animation-delay: 2s;
    }

    @keyframes  float {
      0% { transform: translateY(0) rotate(0deg); }
      50% { transform: translateY(-40px) rotate(15deg); }
      100% { transform: translateY(0) rotate(0deg); }
    }

    .glow-border {
      position: absolute;
      inset: 0;
      border-radius: 1.5rem;
      padding: 2px;
      background: linear-gradient(45deg, #8b5cf6, #6366f1, #3b82f6);
      -webkit-mask: linear-gradient(#fff 0 0) content-box, linear-gradient(#fff 0 0);
      -webkit-mask-composite: xor;
              mask-composite: exclude;
    }
  </style>
</head>

<body>
  <!-- Animated Background Lights -->
  <div class="floating-bg bg1"></div>
  <div class="floating-bg bg2"></div>

  <!-- Login Card -->
  <div class="glass-card z-10 w-[90%] max-w-md p-8 text-white relative">
    <div class="glow-border"></div>
    <div class="relative z-10">
      <div class="text-center mb-8">
        <div class="flex justify-center items-center mb-4">
          <i class="fa-solid fa-shield-halved text-5xl text-indigo-400 animate-pulse"></i>
        </div>
        <h2 class="text-3xl font-bold tracking-wide mb-1">Neon Bubble Quest Admin</h2>
        <p class="text-sm text-indigo-200">Sign in to continue to your dashboard</p>
      </div>

      <!-- Login Form -->
      <form method="POST" action="<?php echo e(route('admin.login')); ?>">
        <?php echo csrf_field(); ?>
        <input type="hidden" name="login" />

        <div class="mb-5">
          <label for="email" class="block text-sm mb-2 text-indigo-100">Email Address</label>
          <div class="relative">
            <input
              type="email"
              id="email"
              name="email"
              required
              class="w-full rounded-xl bg-white/10 px-4 py-3 pl-10 text-white placeholder-slate-300 focus:outline-none focus:ring-2 focus:ring-indigo-400"
              placeholder="Enter your email"
            />
            <i class="fa fa-envelope absolute left-3 top-3.5 text-slate-300"></i>
          </div>
          <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
          <p class="text-red-400 text-sm mt-1"><?php echo e($message); ?></p>
          <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>

        <div class="mb-5">
          <label for="password" class="block text-sm mb-2 text-indigo-100">Password</label>
          <div class="relative">
            <input
              type="password"
              id="password"
              name="password"
              required
              class="w-full rounded-xl bg-white/10 px-4 py-3 pl-10 text-white placeholder-slate-300 focus:outline-none focus:ring-2 focus:ring-indigo-400"
              placeholder="Enter your password"
            />
            <i class="fa fa-lock absolute left-3 top-3.5 text-slate-300"></i>
          </div>
          <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
          <p class="text-red-400 text-sm mt-1"><?php echo e($message); ?></p>
          <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>

        <div class="flex justify-between items-center mb-6">
          <label class="flex items-center text-sm text-slate-200">
            <input type="checkbox" name="remember" class="mr-2 accent-indigo-500" />
            Remember me
          </label>
          <a href="#" class="text-xs text-indigo-300 hover:underline">Forgot Password?</a>
        </div>

        <button
          type="submit"
          class="w-full bg-gradient-to-r from-indigo-500 to-purple-600 hover:from-indigo-600 hover:to-purple-700 text-white font-semibold py-3 rounded-xl shadow-lg transition duration-200"
        >
          <i class="fa fa-right-to-bracket mr-2"></i> Log In
        </button>
      </form>

      <!-- Footer -->
      <p class="text-center text-xs text-indigo-200 mt-8">
        Developed by <span class="font-semibold text-white">Burhan Store</span> © <?php echo e(date('Y')); ?>

      </p>
    </div>
  </div>
</body>
</html>
<?php /**PATH C:\Users\Md Burhan Uddin\Desktop\Game With Reward\admin\resources\views/admin/auth/login.blade.php ENDPATH**/ ?>