<?php

namespace App\Http\Controllers;

use App\Http\Controllers\AppHandler\AppData;
use App\Http\Controllers\AppHandler\Splash;
use Illuminate\Http\Request;
use App\Http\Controllers\AppHandler\User\Signup;
 



class RequestHandler extends Controller
{
  
 
 
public function request(Request $request)
{


    $data = $request->all();

    switch ($data['action']) {
        case 'splash':
            return Splash::usercheck($request);
        case 'register':
            return Signup::register($request);
        case 'get_banner':
            return AppData::get_banner($request);
        case 'get_dailydata':
            return AppData::get_dailydata($request);
        case 'get_quiztask':
            return AppData::get_quiztask($request);  
        case 'get_reward_vault':
            return AppData::get_reward_vault($request);    
        case 'get_pyament_methods':
            return AppData::get_pyament_methods($request);       
        case 'send_redeem_request':
            return AppData::send_redeem_request($request);        
        case 'get_earnhistory':
            return AppData::get_earnhistory($request);     
        case 'get_redeems':
            return AppData::get_redeems($request);     
        case 'delete_account':
            return AppData::delete_account($request);       
        case 'generate_caption':
            return AppData::generate_caption($request);     
        case 'generate_hashtags':
            return AppData::generate_hashtags($request);     
        case 'get_amountpy':
            return AppData::get_amountpy($request);     
        case 'get_leader':
            return AppData::get_leader($request);     
            


            
  
        default:
            return response()->json(['error' => 'Invalid action'], 400);
    }



}



}
